% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialestimate.R
\name{initialestimate}
\alias{initialestimate}
\title{Initialize Parameters for a FMM from Labeled Subset}
\usage{
initialestimate(dat, zm, g, ncov = 2, ridge = 1e-06)
}
\arguments{
\item{dat}{A numeric matrix or data frame of features (n x p).}

\item{zm}{Integer vector of length n with class labels in \code{1:g}; use
\code{NA} for unlabeled rows. Only labeled rows contribute to the
initialization.}

\item{g}{Integer, number of mixture components.}

\item{ncov}{Integer, \code{1} for a shared covariance matrix, \code{2} for
class-specific covariance matrices. Default \code{2}.}

\item{ridge}{Numeric, small diagonal ridge added to covariance(s) for
numerical stability. Default \code{1e-6}.}
}
\value{
A list with
\itemize{
\item \code{pi}: length-\code{g} vector of mixing proportions (summing to 1).
\item \code{mu}: \code{p x g} matrix of class means (column \code{i} is \eqn{\mu_i}).
\item \code{sigma}: if \code{ncov = 1}, a \code{p x p} shared covariance matrix;
if \code{ncov = 2}, a \code{p x p x g} array of class-specific covariances.
}
}
\description{
Builds initial estimates \eqn{(\pi, \mu, \Sigma)} for a g-component Gaussian
mixture using only rows with observed labels in \code{zm}. Supports either a
shared covariance (\code{ncov = 1}) or class-specific covariances
(\code{ncov = 2}).
}
\details{
If a class has zero or one labeled sample, its covariance is set to the global
empirical covariance (from labeled data) with a small ridge. Class means for
empty classes default to the global mean with a small jitter.
}
\examples{
set.seed(1)
n <- 50; p <- 3; g <- 2
X <- matrix(rnorm(n*p), n, p)
z <- sample(c(1:g, NA), n, replace = TRUE, prob = c(0.4, 0.4, 0.2))
init <- initialestimate(X, z, g, ncov = 2)
str(init)

}
