% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_clusterprobs.R
\name{get_clusterprobs}
\alias{get_clusterprobs}
\title{Posterior Cluster Probabilities for a Gaussian Mixture}
\usage{
get_clusterprobs(
  dat,
  n,
  p,
  g,
  pi = NULL,
  mu = NULL,
  sigma = NULL,
  paralist = NULL
)
}
\arguments{
\item{dat}{Numeric matrix \eqn{n \times p}. Data matrix (rows = observations).}

\item{n}{Integer. Number of observations (checked against \code{nrow(dat)}).}

\item{p}{Integer. Number of variables (checked against \code{ncol(dat)}).}

\item{g}{Integer. Number of components.}

\item{pi}{Optional numeric vector length \eqn{g}. Mixing proportions (sum to 1).}

\item{mu}{Optional numeric matrix \eqn{p \times g}. Column \eqn{i} is mean of component \eqn{i}.}

\item{sigma}{Optional numeric matrix \eqn{p \times p} (shared covariance) or
array \eqn{p \times p \times g} (component-specific covariances).}

\item{paralist}{Optional list with elements \code{pi}, \code{mu}, \code{sigma}.
If provided, these take precedence over the corresponding explicit args.}
}
\value{
Numeric matrix \eqn{n \times g} of posterior probabilities \eqn{\tau_{ij}}.
}
\description{
Compute posterior membership probabilities \eqn{\tau_{ij}} for each
observation under a Gaussian mixture with either a shared covariance
matrix or component-specific covariances.
}
\examples{
  n <- 100; p <- 2; g <- 2
  X <- matrix(rnorm(n*p), n, p)
  pi <- c(0.6, 0.4)
  mu <- cbind(c(0,0), c(1,1))
  Sig <- array(0, dim = c(p,p,g)); Sig[,,1] <- diag(p); Sig[,,2] <- diag(p)
  tau <- get_clusterprobs(X, n, p, g, pi = pi, mu = mu, sigma = Sig)
  head(tau)

}
