% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCrabs.R
\docType{data}
\name{HCrabs}
\alias{HCrabs}
\title{Hermit crabs}
\format{
A data frame with 173 rows (each crab) and 5 columns:
\describe{
  \item{Col}{The female's carapace colour; one of \code{LM} (light medium), \code{M} (medium), \code{DM} (dark medium) or \code{D} (dark)}
  \item{Spine}{The female's spine condition; one of \code{BothOK}, \code{OneOK} or \code{NoneOK}}
  \item{Width}{The female's carapace width, in cm}
  \item{Wt}{The weight of the female, in grams}
  \item{Sat}{The number of male crabs attached ('satellites')}
}
}
\source{
H. J. Brockmann (1996) Satellite male groups in horseshoe crabs, 
\emph{Limulus polyphemus}. 
\emph{Ethology}, \bold{102}(1), 1--21.
}
\usage{
data(HCrabs)
}
\description{
The number of male crabs attached to female horseshoe crabs
}
\examples{
barplot( xtabs( ~ Col + Spine, data = HCrabs), ylab = "Number of female crabs")

}
\keyword{datasets}
