% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worms_api_functions.R
\name{get_worms_classification}
\alias{get_worms_classification}
\title{Retrieve hierarchical classification from WoRMS}
\usage{
get_worms_classification(
  aphia_ids,
  add_rank_to_hierarchy = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{aphia_ids}{Numeric vector of AphiaIDs to retrieve classification for.
Must not be NULL or empty. Duplicates are allowed and will be preserved
in the output.}

\item{add_rank_to_hierarchy}{Logical (default FALSE). If TRUE, the hierarchy
string prepends rank names (e.g., \verb{[Kingdom] Animalia - [Phylum] Chordata})
to each taxon name in the \code{worms_hierarchy} column. Only applies if
\code{worms_hierarchy} is present.}

\item{verbose}{Logical (default TRUE). If TRUE, prints progress messages
and a progress bar during data retrieval.}
}
\value{
A \code{tibble} where each row corresponds to an input AphiaID. Typical
columns include:
\describe{
\item{aphia_id}{The AphiaID of the taxon (matches input).}
\item{scientific_name}{The last scientific name in the hierarchy for
this AphiaID.}
\item{taxonomic ranks}{Columns for each rank present in the WoRMS
hierarchy (e.g., Kingdom, Phylum, Class, Order, Family, Genus,
Species). Missing ranks are NA.}
\item{worms_hierarchy}{A concatenated string of all ranks for this
AphiaID. Added for every row if \code{wm_classification()} returned
hierarchy data. Format depends on \code{add_rank_to_hierarchy}.}
}
}
\description{
Retrieves the hierarchical taxonomy for one or more AphiaIDs from the
World Register of Marine Species (WoRMS) and returns it in a wide format.
Optionally, a hierarchy string column can be added that concatenates ranks.
}
\details{
The function performs the following steps:
\enumerate{
\item Validates input AphiaIDs and removes NA values.
\item Retrieves the hierarchical classification for each AphiaID using
\code{worrms::wm_classification()}.
\item Converts the hierarchy to a wide format with one column per rank.
\item Adds a \code{worms_hierarchy} string concatenating all ranks.
\item Preserves input order and duplicates.
}
}
\examples{
\donttest{
# Single AphiaID
single_taxa <- get_worms_classification(109604, verbose = FALSE)
print(single_taxa)

# Multiple AphiaIDs
multiple_taxa <- get_worms_classification(c(109604, 376667), verbose = FALSE)
print(multiple_taxa)

# Hierarchy with ranks in the string
with_rank <- get_worms_classification(c(109604, 376667),
                                      add_rank_to_hierarchy = TRUE,
                                      verbose = FALSE)

# Print hierarchy columns with ranks
print(with_rank$worms_hierarchy[1])

# Compare with result when add_rank_to_hierarchy = FALSE
print(multiple_taxa$worms_hierarchy[1])
}

}
\seealso{
\code{\link[worrms]{wm_classification}}, \url{https://marinespecies.org/}
}
