% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samLL.R
\name{samLL}
\alias{samLL}
\title{Training function of Sparse Additive Logistic Regression}
\usage{
samLL(
  X,
  y,
  p = 3,
  lambda = NULL,
  nlambda = NULL,
  lambda.min.ratio = 0.1,
  thol = 1e-05,
  max.ite = 1e+05,
  regfunc = "L1"
)
}
\arguments{
\item{X}{Numeric training matrix with \code{n} rows (samples) and \code{d}
columns (features).}

\item{y}{Binary training labels of length \code{n}. Labels must be coded as
\code{0} and \code{1}.}

\item{p}{The number of basis spline functions. The default value is 3.}

\item{lambda}{Optional user-supplied regularization sequence. If provided,
use a decreasing sequence; warm starts are used along the path and are
usually much faster than fitting a single value.}

\item{nlambda}{The number of lambda values. The default value is 20.}

\item{lambda.min.ratio}{Smallest lambda as a fraction of \code{lambda.max}
(the smallest value that keeps all component functions at zero). The
default is \code{0.1}.}

\item{thol}{Stopping tolerance. The default value is \code{1e-5}.}

\item{max.ite}{Maximum number of iterations. The default value is \code{1e5}.}

\item{regfunc}{A string indicating the regularizer. The default value is "L1". You can also assign "MCP" or "SCAD" to it.}
}
\value{
\item{p}{
  The number of basis spline functions used in training.
}
\item{X.min}{
  Per-feature minimums from training data (used to rescale test data).
}
\item{X.ran}{
  Per-feature ranges from training data (used to rescale test data).
}
\item{lambda}{
  Sequence of regularization parameters used in training.
}
\item{w}{
  Solution path matrix with size \code{d*p+1} by \code{length(lambda)}; each column corresponds to one regularization parameter.
}
\item{df}{
  Degrees of freedom along the solution path (number of non-zero component
  functions).
}
\item{knots}{
  The \code{p-1} by \code{d} matrix. Each column contains the knots applied to the corresponding variable.
}
\item{Boundary.knots}{
  The \code{2} by \code{d} matrix. Each column contains the boundary points applied to the corresponding variable.
}
\item{func_norm}{
  Functional norm matrix (\code{d} by \code{length(lambda)}); each column
  corresponds to one regularization parameter.
}
}
\description{
Fit a sparse additive logistic regression model on training data.
}
\details{
The solver combines block coordinate descent, fast iterative soft-thresholding,
and Newton updates. Computation is accelerated by warm starts and active-set
screening.
}
\examples{

## generating training data
n = 200
d = 100
X = 0.5*matrix(runif(n*d),n,d) + matrix(rep(0.5*runif(n),d),n,d)
y = sign(((X[,1]-0.5)^2 + (X[,2]-0.5)^2)-0.06)

## flipping about 5 percent of y
y = y*sign(runif(n)-0.05)
y = sign(y==1)

## Training
out.trn = samLL(X,y)
out.trn

## plotting solution path
plot(out.trn)

## generating testing data
nt = 1000
Xt = 0.5*matrix(runif(nt*d),nt,d) + matrix(rep(0.5*runif(nt),d),nt,d)

yt = sign(((Xt[,1]-0.5)^2 + (Xt[,2]-0.5)^2)-0.06)

## flipping about 5 percent of y
yt = yt*sign(runif(nt)-0.05)
yt = sign(yt==1)

## predicting response
out.tst = predict(out.trn,Xt)
}
\seealso{
\code{\link{SAM}},\code{\link{plot.samLL},\link{print.samLL},\link{predict.samLL}}
}
