library(testthat)
library(RealSurvSim)

original_data <- dats$Liang
# Assuming data_simul_KDE and original_data are loaded appropriately

test_that("data is correctly split and simulated", {
  # Split the data according to treatment groups and censoring status
  split_data <- split(original_data, with(original_data, paste(V2, V3, sep="_")))

  # Perform simulations
  simulated_data <- lapply(split_data, function(group_data) {
    data_simul_KDE(group_data$V1, n = 50)  # Assuming the KDE function takes a numeric vector and desired output size
  })

  # Check for correct output type and length
  lapply(simulated_data, function(sim_data) {
    expect_type(sim_data, "double")
    expect_length(sim_data, 50)
  })
})

test_that("Error on non-numeric input", {
  # Ensure non-numeric input is handled
  expect_error(data_simul_KDE("some non-numeric input"), "orig_vals must be a numeric vector.")
})

test_that("Handling of unsupported kernel", {
  # Test for handling unsupported kernels
  expect_error(data_simul_KDE(original_data$V1, kernel = "unsupported_kernel"), "Unsupported kernel type. Currently, only 'gaussian' is supported.")
})

test_that("Handling of empty original data", {
  # Check how the function handles empty input data
  expect_error(data_simul_KDE(numeric(0)), "original data cannot be empty")
})

test_that("Reproducibility of results with set seed", {
  # Check for reproducibility
  set.seed(123)
  a <- data_simul_KDE(original_data$V1, n = 100)
  set.seed(123)
  b <- data_simul_KDE(original_data$V1, n = 100)
  expect_identical(a, b)
})


# Test handling of Inf or NaN within data
test_that("Function handles Inf or NaN within data", {
  data_with_inf <- c(original_data, Inf)
  data_with_nan <- c(original_data, NaN)
  expect_error(data_simul_KDE(data_with_inf), "orig_vals must be a numeric vector.")
  expect_error(data_simul_KDE(data_with_nan), "orig_vals must be a numeric vector.")
})


test_that("data_simul_KDE uses length of orig_vals when n is NULL", {
  # Perform simulation without specifying n
  simulated_data <- data_simul_KDE(original_data$V1)

  # Check if the length of the simulated data is the same as the length of the original data
  expect_length(simulated_data, length(original_data$V1))
})
