% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_long_to_list_matrix.R
\name{long_to_list_matrix}
\alias{long_to_list_matrix}
\title{Generate count data for RSTr object}
\usage{
long_to_list_matrix(
  table,
  event,
  population,
  region,
  group = NULL,
  time = NULL
)
}
\arguments{
\item{table}{A \code{table} containing event and mortality counts stratified by group/region/time.}

\item{event}{The column containing event counts.}

\item{population}{The column containing population counts.}

\item{region}{The column containing region names.}

\item{group}{An optional column containing sociodemographic group names.}

\item{time}{An optional column containing time period names.}
}
\value{
A \code{list} of mortality and population counts organized into multi-dimensional arrays.
}
\description{
\code{long_to_list_matrix()} converts a long \code{table} featuring event counts across regions and other optional margins into a \code{list} that is readable by \code{*car()}.
}
\details{
\code{long_to_list_matrix()} will sum along any group/time stratifications that aren't specified; for example, if your dataset contains time periods and time is not specified in \code{long_to_list_matrix()}, the output will be a sum of all time periods. Filter data by desired groups and time periods before running \code{long_to_list_matrix()}.
}
\examples{
ma_data <- maexample[!is.na(maexample$Year), ]
# Generates data from 1979-1981 stratified by sex
ma_data_mst <- long_to_list_matrix(ma_data, Deaths, Population, County.Code, Sex.Code, Year.Code)
ma_data_79 <- ma_data[ma_data$Year == 1979, ]
# Generates 1979 data stratified by sex
ma_data_m <- long_to_list_matrix(ma_data_79, Deaths, Population, County.Code, Sex.Code)
# Generates 1979 data summarized for all sexes
ma_data_u <- long_to_list_matrix(ma_data_79, Deaths, Population, County.Code)
}
