% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradient.R
\name{G}
\alias{G}
\title{Extract Gradient information}
\usage{
G(x, ...)
}
\arguments{
\item{x}{an object used to select the method.}

\item{\ldots}{further arguments passed down to the
\code{\link[numDeriv]{grad}()} function for calculating gradients 
(only for \code{"F_objective"}).}
}
\value{
a \code{"function"}.
}
\description{
Extract the gradient from its argument (typically a ROI
object of class \code{"objective"}).
}
\details{
By default \pkg{ROI} uses the \code{"grad"} function from the 
  \pkg{numDeriv} package to derive the gradient information.
  An alternative function can be provided via \code{"ROI_options"}.
  For example \code{ROI_options("gradient", myGrad)}
  would tell \pkg{ROI} to use the function \code{"myGrad"} for the
  gradient calculation. The only requirement to the function 
  \code{"myGrad"} is that it has the argument \code{"func"}
  which takes a function with a scalar real result.
}
\examples{
\dontrun{
   f <- function(x) {
       return( 100 * (x[2] - x[1]^2)^2 + (1 - x[1])^2 )
   }
   x <- OP( objective = F_objective(f, n=2L), 
            bounds = V_bound(li=1:2, ui=1:2, lb=c(-3, -3), ub=c(3, 3)) )
   G(objective(x))(c(0, 0)) ## gradient numerically approximated by numDeriv


   f.gradient <- function(x) {
       return( c( -400 * x[1] * (x[2] - x[1] * x[1]) - 2 * (1 - x[1]),
                   200 * (x[2] - x[1] * x[1])) )
   }
   x <- OP( objective = F_objective(f, n=2L, G=f.gradient), 
            bounds = V_bound(li=1:2, ui=1:2, lb=c(-3, -3), ub=c(3, 3)) )
   G(objective(x))(c(0, 0)) ## gradient calculated by f.gradient
}
}
