% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality_control.R
\name{check_replicates}
\alias{check_replicates}
\title{Check Technical Replicates}
\usage{
check_replicates(data, sd_threshold = 0.5)
}
\arguments{
\item{data}{Output from import_plate().}

\item{sd_threshold}{Maximum allowed Standard Deviation between replicates (default 0.5).}
}
\value{
A dataframe of "Bad Wells" to investigate.
}
\description{
Scans the experiment for wells where technical replicates disagree (high standard deviation).
}
\examples{
# Data with a good group (SD=0.1) and a bad group (SD=2.0)
df <- data.frame(
  Sample = c(rep("S1", 3), rep("S2", 3)),
  Gene = "GAPDH",
  Ct = c(20.0, 20.1, 20.2,  25.0, 25.0, 29.0) # S2 has an outlier
)

# Run Check
check_replicates(df, sd_threshold = 0.5)
}
