% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyCharacteristics.R
\name{shinyCharacteristics}
\alias{shinyCharacteristics}
\title{Generate an interactive Shiny application that visualises the results
obtained from the \code{databaseCharacteristics()} function}
\usage{
shinyCharacteristics(
  result,
  directory,
  background = TRUE,
  title = "Database characterisation",
  logo = "ohdsi",
  theme = NULL
)
}
\arguments{
\item{result}{A summarised_result object (output of
\code{databaseCharacteristics()}).}

\item{directory}{A character string specifying the directory where the
application will be saved.}

\item{background}{Background panel for the Shiny app.
\itemize{
\item If set to \code{TRUE} (default), a standard background panel with a general
description will be included.
\item If set to \code{FALSE}, no background panel will be displayed.
\item If it is a path (e.g., \code{"path/to/file.md"}) tha file will be used as
background panel of your shiny App.
}}

\item{title}{Title of the shiny. Default is "Characterisation".}

\item{logo}{Name of a logo or path to a logo. If NULL no logo is included.
Only svg format allowed for the moment.}

\item{theme}{A character string specifying the theme for the Shiny
application. It can be any of the OmopViewer supported themes.}
}
\value{
This function invisibly returns NULL and generates a static Shiny app
in the specified directory.
}
\description{
Generate an interactive Shiny application that visualises the results
obtained from the \code{databaseCharacteristics()} function
}
\examples{
\dontrun{
library(OmopSketch)
library(omock)
library(here)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

res <- databaseCharacteristics(cdm = cdm)

shinyCharacteristics(result = res, directory = here())

cdmDisconnect(cdm = cdm)
}

}
