% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTrend.R
\name{plotTrend}
\alias{plotTrend}
\title{Create a ggplot2 plot from the output of summariseTrend()}
\usage{
plotTrend(
  result,
  output = NULL,
  facet = "type",
  colour = NULL,
  style = NULL,
  type = NULL
)
}
\arguments{
\item{result}{A summarised_result object (output of \code{summariseTrend()}).}

\item{output}{The output to plot.  Accepted values are: \code{"record"}, \code{"person"},
\code{"person-days"}, \code{"age"}, and \code{"sex"}.
If not specified, the function will default to:
\itemize{
\item the only available output if there is just one in the results, or
\item \code{"record"} if multiple outputs are present.
}}

\item{facet}{Columns to face by. Formula format can be provided. See possible
columns to face by with: \code{visOmopResults::tidyColumns()}.}

\item{colour}{Columns to colour by. See possible columns to colour by with:
\code{visOmopResults::tidyColumns()}.}

\item{style}{Visual theme to apply. Character, or \code{NULL}. If a character,
this may be either the name of a built-in style (see
\code{visOmopResults::plotStyle()}), or a path to a .yml file that defines a
custom style. If \code{NULL}, the function will use the explicit default style,
unless a global style option is set (see \code{visOmopResults::setGlobalPlotOptions()})
or a _brand.yml file is present (in that order).}

\item{type}{Character string indicating the output plot format. See
\code{visOmopResults::plotType()} for the list of supported plot types. If
\code{type = NULL}, the function will use the global setting defined via
\code{visOmopResults::setGlobalPlotOptions()} (if available); otherwise, a
standard \code{ggplot2} plot is produced by default.}
}
\value{
A plot visualisation.
}
\description{
Create a ggplot2 plot from the output of summariseTrend()
}
\examples{
\donttest{
library(dplyr)
library(OmopSketch)
library(omock)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

result <- summariseTrend(cdm,
  episode = "observation_period",
  output = c("person-days", "record"),
  interval = "years",
  ageGroup = list("<=40" = c(0, 40), ">40" = c(41, Inf)),
  sex = TRUE
)

plotTrend(
  result = result,
  output = "record",
  colour = "sex",
  facet = "age_group"
)

cdmDisconnect(cdm = cdm)
}

}
