% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionQueries.R
\name{getPredictionCohorts}
\alias{getPredictionCohorts}
\title{Extract a complete set of cohorts used in the prediction results}
\usage{
getPredictionCohorts(
  connectionHandler,
  schema,
  plpTablePrefix = "plp_",
  cgTablePrefix = "cg_"
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{plpTablePrefix}{The prefix used for the patient level prediction results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}
}
\value{
Returns a data.frame with the columns: 
\itemize{
 \item{cohortId the cohort definition ID}
 \item{cohortName the name of the cohort}
 \item{type whether the cohort was used as a target or outcome cohort}
}
}
\description{
This function extracts the target and outcome cohorts used to develop any model in the results
}
\details{
Specify the connectionHandler, the resultDatabaseSettings and any targetIds or outcomeIds to restrict models to
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

predCohorts <- getPredictionCohorts(
  connectionHandler = connectionHandler, 
  schema = 'main'
)

}
\seealso{
Other Prediction: 
\code{\link{getFullPredictionPerformances}()},
\code{\link{getPredictionAggregateTopPredictors}()},
\code{\link{getPredictionCovariates}()},
\code{\link{getPredictionDiagnosticTable}()},
\code{\link{getPredictionDiagnostics}()},
\code{\link{getPredictionHyperParamSearch}()},
\code{\link{getPredictionIntercept}()},
\code{\link{getPredictionLift}()},
\code{\link{getPredictionModelDesigns}()},
\code{\link{getPredictionOutcomes}()},
\code{\link{getPredictionPerformanceTable}()},
\code{\link{getPredictionPerformances}()},
\code{\link{getPredictionTargets}()},
\code{\link{getPredictionTopPredictors}()}
}
\concept{Prediction}
