#' Calculate NUE of a Food Chain (NUEFC)
#' @description
#' The N balance of the entire food chain system.
#' Formula: NUEFC = Ncon / Ni
#' @param Ncon The value of N available for consumption.
#' @param Ni Sum total of new N input.
#' @return A numeric vector of NUEFC values.
#' @examples
#' Ncon <- c(40, 45)
#' Ni <- c(100, 110)
#' NUEFC(Ncon, Ni)
#' @export
NUEFC <- function(Ncon, Ni) {
  if (any(Ni == 0)) stop("Input N (Ni) cannot be zero.")
  return(Ncon / Ni)
}