#' Summary Method for NNMoMo Objects
#'
#' Method for printing the summary of \code{\link{lcNN}}. Gives detailed
#' infofmation about the object.
#'
#' @param object An object of class \code{NNMoMo}.
#' @param ... Further arguments passed to or from other methods.
#'
#' @return Displays a summary of the \code{NNMoMo} object in the console.
#'
#' @export
summary.NNMoMo <- function(object, ...) {
  cat("Summary of NNMoMo object:\n")
  cat("  Model type :", object$model_type, "\n")
  cat("  Activation :", object$activation, "\n")
  cat("  Loss       :", object$loss_type, "\n")
  cat("  q_e        :", object$q_e, "\n")
  cat("  q_z1       :", object$q_z1, "\n")
}
