% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{MetaRVMCheck}
\alias{MetaRVMCheck}
\title{MetaRVM Checkpoint Class}
\description{
R6 class to handle MetaRVM checkpoint data. This class is a simplified
version of \link{MetaRVMConfig} tailored for storing and accessing simulation
checkpoints.
}
\details{
The \code{MetaRVMCheck} class is designed to hold the state of a simulation at a
specific time point, allowing for continuation or analysis. It stores all
necessary parameters and population states.
}
\author{
Arindam Fadikar
}
\section{Super class}{
\code{\link[MetaRVM:MetaRVMConfig]{MetaRVM::MetaRVMConfig}} -> \code{MetaRVMCheck}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{check_data}}{List containing all parsed checkpoint data}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MetaRVMCheck-new}{\code{MetaRVMCheck$new()}}
\item \href{#method-MetaRVMCheck-clone}{\code{MetaRVMCheck$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="MetaRVM" data-topic="MetaRVMConfig" data-id="get"><a href='../../MetaRVM/html/MetaRVMConfig.html#method-MetaRVMConfig-get'><code>MetaRVM::MetaRVMConfig$get()</code></a></span></li>
<li><span class="pkg-link" data-pkg="MetaRVM" data-topic="MetaRVMConfig" data-id="get_age_categories"><a href='../../MetaRVM/html/MetaRVMConfig.html#method-MetaRVMConfig-get_age_categories'><code>MetaRVM::MetaRVMConfig$get_age_categories()</code></a></span></li>
<li><span class="pkg-link" data-pkg="MetaRVM" data-topic="MetaRVMConfig" data-id="get_all"><a href='../../MetaRVM/html/MetaRVMConfig.html#method-MetaRVMConfig-get_all'><code>MetaRVM::MetaRVMConfig$get_all()</code></a></span></li>
<li><span class="pkg-link" data-pkg="MetaRVM" data-topic="MetaRVMConfig" data-id="get_pop_map"><a href='../../MetaRVM/html/MetaRVMConfig.html#method-MetaRVMConfig-get_pop_map'><code>MetaRVM::MetaRVMConfig$get_pop_map()</code></a></span></li>
<li><span class="pkg-link" data-pkg="MetaRVM" data-topic="MetaRVMConfig" data-id="get_race_categories"><a href='../../MetaRVM/html/MetaRVMConfig.html#method-MetaRVMConfig-get_race_categories'><code>MetaRVM::MetaRVMConfig$get_race_categories()</code></a></span></li>
<li><span class="pkg-link" data-pkg="MetaRVM" data-topic="MetaRVMConfig" data-id="get_zones"><a href='../../MetaRVM/html/MetaRVMConfig.html#method-MetaRVMConfig-get_zones'><code>MetaRVM::MetaRVMConfig$get_zones()</code></a></span></li>
<li><span class="pkg-link" data-pkg="MetaRVM" data-topic="MetaRVMConfig" data-id="list_parameters"><a href='../../MetaRVM/html/MetaRVMConfig.html#method-MetaRVMConfig-list_parameters'><code>MetaRVM::MetaRVMConfig$list_parameters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="MetaRVM" data-topic="MetaRVMConfig" data-id="parameter_summary"><a href='../../MetaRVM/html/MetaRVMConfig.html#method-MetaRVMConfig-parameter_summary'><code>MetaRVM::MetaRVMConfig$parameter_summary()</code></a></span></li>
<li><span class="pkg-link" data-pkg="MetaRVM" data-topic="MetaRVMConfig" data-id="print"><a href='../../MetaRVM/html/MetaRVMConfig.html#method-MetaRVMConfig-print'><code>MetaRVM::MetaRVMConfig$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="MetaRVM" data-topic="MetaRVMConfig" data-id="set"><a href='../../MetaRVM/html/MetaRVMConfig.html#method-MetaRVMConfig-set'><code>MetaRVM::MetaRVMConfig$set()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMCheck-new"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMCheck-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new MetaRVMCheck object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMCheck$new(input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{A list containing checkpoint data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{MetaRVMCheck} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MetaRVMCheck-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MetaRVMCheck-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MetaRVMCheck$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
