% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaHDInput.R
\name{MetaHDInput}
\alias{MetaHDInput}
\title{Creating Input Data for MetaHD When Individual-Level Data are Available}
\usage{
MetaHDInput(data)
}
\arguments{
\item{data}{a dataframe consisting of individual-level data in the format, where 'study' in column 1, 'group' in column 2 and outcomes in rest of the columns and samples in rows.}
}
\value{
A list of objects containing :
\itemize{
\item \code{Y}: A \eqn{K \times N} matrix of treatment effect sizes, where \eqn{K} is the number of studies and \eqn{N} is the number of outcomes.
\item \code{Slist}: A list of length \eqn{K} containing \eqn{N \times N} within-study variance–covariance matrices of the treatment effects.
}
}
\description{
The MetaHDInput function creates input data \code{Y} (treatment effects) and \code{Slist} (within-study covariance matrices) for \code{MetaHD} when individual-level data are available. Assuming that the individual-level data are in the following format, with 'study' in column 1, 'group' in column 2 and outcomes in rest of the columns, with samples in rows.
}
\examples{
# CREATE INPUT DATA
input_data <- MetaHDInput(realdata)

## treatment effect-sizes
Y <- input_data$Y
head(Y)

## within-study variance–covariance matrices
Slist <- input_data$Slist
head(Slist[[1]])

}
