% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMeasurementSummary.R
\name{plotMeasurementSummary}
\alias{plotMeasurementSummary}
\title{Plot summariseMeasurementTiming results.}
\usage{
plotMeasurementSummary(
  result,
  y = "time",
  plotType = "boxplot",
  timeScale = "days",
  facet = visOmopResults::strataColumns(result),
  colour = c("cdm_name", "codelist_name"),
  style = NULL
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{y}{Variable to plot on y axis, it can be "time" or
"measurements_per_subject".}

\item{plotType}{Type of plot, either "boxplot", "barplot", or "densityplot".}

\item{timeScale}{Time scale to show, it can be "days" or "years".}

\item{facet}{Columns to facet by. See options with
`visOmopResults::plotColumns(result)`. Formula input is also allowed to
specify rows and columns.}

\item{colour}{Columns to color by. See options with
`visOmopResults::plotColumns(result)`.}

\item{style}{Pre-defined style to apply: "default" or
"darwin" - the latter just for gt and flextable. If NULL the "default" style
is used.}
}
\value{
A ggplot.
}
\description{
Plot summariseMeasurementTiming results.
}
\examples{
\donttest{
library(MeasurementDiagnostics)
library(dplyr)

cdm <- mockMeasurementDiagnostics()

result <- summariseMeasurementUse(
  cdm = cdm,
  codes = list("test_codelist" = c(3001467L, 45875977L))
)

result |>
  filter(variable_name == "time") |>
  plotMeasurementSummary()

CDMConnector::cdmDisconnect(cdm)
}
}
