% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vs_mram.R
\name{vs_mram}
\alias{vs_mram}
\title{Variable Selection via the Multivariate Regression Association Measure}
\usage{
vs_mram(y_data, x_data)
}
\arguments{
\item{y_data}{A \eqn{n \times d} matrix of responses, where \eqn{n} is the sample size.}

\item{x_data}{A \eqn{n \times p} matrix of predictors.}
}
\value{
The vector containing the indices of the selected predictors in the order they were chosen.
}
\description{
Select a subset of \eqn{\bf X} which can be used to predict \eqn{\bf Y} based on \eqn{T_n}.
}
\details{
\code{vs_mram} performs forward stepwise variable selection based on the multivariate regression association measure proposed in Shih and Chen (2025). At each step, it selects the predictor with the highest conditional predictability for the response given the previously selected predictors. The algorithm is modified from the FOCI algorithm from Azadkia and Chatterjee (2021).
}
\examples{
library(MRAM)

n = 200
p = 10

set.seed(1)
x_data = matrix(rnorm(p*n),n,p)
colnames(x_data) = paste0(rep("X",p),seq(1,p))

y_data = x_data[,1]*x_data[,2]+x_data[,1]-x_data[,3]+rnorm(n)
colnames(x_data)[vs_mram(y_data,x_data)] # selected variables

\dontrun{

n = 500
p = 10

set.seed(1)
x_data = matrix(rnorm(p*n),n,p)
colnames(x_data) = paste0(rep("X",p),seq(1,p))

# Linear
y_data = matrix(0,n,2)
y_data[,1] = x_data[,1]*x_data[,2]+x_data[,1]-x_data[,3]+rnorm(n)
y_data[,2] = x_data[,2]*x_data[,4]+x_data[,2]-x_data[,5]+rnorm(n)
colnames(x_data)[vs_mram(y_data,x_data)] # selected variables

# Nonlinear
y_data = matrix(0,n,2)
y_data[,1] = x_data[,1]*x_data[,2]+sin(x_data[,1]*x_data[,3])+0.3*rnorm(n)
y_data[,2] = cos(x_data[,2]*x_data[,4])+x_data[,3]-x_data[,4]+0.3*rnorm(n)
colnames(x_data)[vs_mram(y_data,x_data)] # selected variables

# Non-additive error
y_data = matrix(0,n,2)
y_data[,1] = abs(x_data[,1]+runif(n))^(sin(x_data[,2])-cos(x_data[,3]))
y_data[,2] = abs(x_data[,2]-runif(n))^(sin(x_data[,3])-cos(x_data[,4]))
colnames(x_data)[vs_mram(y_data,x_data)] # selected variables
}
}
\references{
Azadkia and Chatterjee (2021) A simple measure of conditional dependence, Annals of Statistics, 46(6): 3070-3102.

Shih and Chen (2026) Measuring multivariate regression association via spatial sign, Computational Statistics & Data Analysis, 215, 108288.
}
\seealso{
\code{\link{mram}}
}
