% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa.R
\name{apa}
\alias{apa}
\title{Format numbers for APA-style reporting}
\usage{
apa(value, decimals = 3, leading = TRUE)
}
\arguments{
\item{value}{Numeric input: a single number, vector, matrix, or a data frame
with all-numeric columns. Non-numeric inputs will error.}

\item{decimals}{A single non-negative integer giving the number of decimal
places to keep in the output.}

\item{leading}{Logical: `TRUE` to keep leading zeros on decimals (e.g.,
`0.25`), `FALSE` to drop them (e.g., `.25`). Default is `TRUE`.}
}
\value{
A character vector/array (matching the shape of `value`) containing
  the formatted numbers.
}
\description{
Create "pretty" character representations of numeric values with a fixed
number of decimal places, optionally keeping or omitting the leading zero
for values between -1 and 1.
}
\details{
This function formats numbers for inclusion in manuscripts and reports.
- When `leading = TRUE`, numbers are rounded and padded to `decimals`
  places, keeping the leading zero for values with absolute value < 1.
- When `leading = FALSE`, the leading zero before the decimal point is
  removed for values with absolute value < 1.
If `value` is a data frame, all columns must be numeric; otherwise an error
is thrown.
}
\examples{
apa(0.54674, decimals = 3, leading = TRUE)   # "0.547"
apa(c(0.2, 1.2345, -0.04), decimals = 2)     # "0.20" "1.23" "-0.04"
apa(matrix(c(0.12, -0.9, 2.3, 10.5), 2), decimals = 1, leading = FALSE)
# returns a character matrix with ".1", "-.9", "2.3", "10.5"
}
