% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_midpointCE.R
\name{midpointCE}
\alias{midpointCE}
\title{Midpoint of cumulative light exposure.}
\usage{
midpointCE(Light.vector, Time.vector, na.rm = FALSE, as.df = FALSE)
}
\arguments{
\item{Light.vector}{Numeric vector containing the light data.}

\item{Time.vector}{Vector containing the time data. Can be \link[base]{POSIXct}, \link[hms]{hms},
\link[lubridate]{duration}, or \link[base]{difftime}.}

\item{na.rm}{Logical. Should missing values be removed for the calculation? If \code{TRUE},
missing values will be replaced by zero. Defaults to \code{FALSE}.}

\item{as.df}{Logical. Should the output be returned as a data frame? If \code{TRUE}, a data
frame with a single column named \code{midpointCE} will be returned.
Defaults to \code{FALSE}.}
}
\value{
Single column data frame or vector.
}
\description{
This function calculates the timing corresponding to half of the cumulative
light exposure within the given time series.
}
\examples{
dataset1 <-
  tibble::tibble(
    Id = rep("A", 24),
    Datetime = lubridate::as_datetime(0) + lubridate::hours(0:23),
    MEDI = c(rep(1, 6), rep(250, 13), rep(1, 5))
  )
dataset1 \%>\%
  dplyr::reframe(
    "Midpoint of cmulative exposure" = midpointCE(MEDI, Datetime)
  )

# Dataset with HMS time vector
dataset2 <-
  tibble::tibble(
    Id = rep("A", 24),
    Time = hms::as_hms(lubridate::as_datetime(0) + lubridate::hours(0:23)),
    MEDI = c(rep(1, 6), rep(250, 13), rep(1, 5))
  )
dataset2 \%>\%
  dplyr::reframe(
    "Midpoint of cmulative exposure" = midpointCE(MEDI, Time)
  )

# Dataset with duration time vector
dataset3 <-
  tibble::tibble(
    Id = rep("A", 24),
    Hour = lubridate::duration(0:23, "hours"),
    MEDI = c(rep(1, 6), rep(250, 13), rep(1, 5))
  )
dataset3 \%>\%
  dplyr::reframe(
    "Midpoint of cmulative exposure" = midpointCE(MEDI, Hour)
  )

}
\references{
Shochat, T., Santhi, N., Herer, P., Flavell, S. A., Skeldon, A. C.,
& Dijk, D.-J. (2019). Sleep Timing in Late Autumn and Late Spring Associates
With Light Exposure Rather Than Sun Time in College Students.
\emph{Frontiers in Neuroscience}, 13. \doi{10.3389/fnins.2019.00882}

Hartmeyer, S.L., Andersen, M. (2023). Towards a framework for light-dosimetry studies:
Quantification metrics. \emph{Lighting Research & Technology}.
\doi{10.1177/14771535231170500}
}
\seealso{
Other metrics: 
\code{\link{bright_dark_period}()},
\code{\link{centroidLE}()},
\code{\link{disparity_index}()},
\code{\link{dose}()},
\code{\link{duration_above_threshold}()},
\code{\link{exponential_moving_average}()},
\code{\link{frequency_crossing_threshold}()},
\code{\link{interdaily_stability}()},
\code{\link{intradaily_variability}()},
\code{\link{nvRC}()},
\code{\link{nvRD}()},
\code{\link{nvRD_cumulative_response}()},
\code{\link{period_above_threshold}()},
\code{\link{pulses_above_threshold}()},
\code{\link{threshold_for_duration}()},
\code{\link{timing_above_threshold}()}
}
\concept{metrics}
