% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosscorr.R
\name{cross_corr}
\alias{cross_corr}
\alias{cross_corr_plot}
\title{Cross-correlation of MCMC samples}
\usage{
cross_corr(object, outcome = 1L, start = NULL, end = NULL, thin = NULL)

cross_corr_plot(object, outcome = 1L, start = NULL, end = NULL,
  thin = NULL, type = "corrplot")
}
\arguments{
\item{object}{an object of class JointAI}

\item{outcome}{integer; index of the outcome model for which the
correlations should be plotted}

\item{start}{the first iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (integer; see \code{\link[coda]{window.mcmc}}).
For example, \code{thin = 1} (default) will keep the MCMC samples
from all iterations; \code{thin = 5} would only keep every 5th
iteration.}

\item{type}{character; type of plot to be produced. Either "corrplot"
(default) or "coda".}
}
\value{
a matrix (or a plot)
}
\description{
These functions compute the cross-correlations of the MCMC samples in an
JointAI object via \code{coda::crosscorr()} and plot them using either the
\strong{corrplot} package or \code{coda::crosscorr.plot()}.
}
\examples{
fit <- lm_imp(y ~ C1 + C2 + B2, data = wideDF, n.iter = 200)
cross_corr(fit)
cross_corr_plot(fit, type = "coda")
}
