% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{jpn_prefectures_tbl_df}
\alias{jpn_prefectures_tbl_df}
\title{Japan Prefectures 7x7 Grid Dataset}
\format{
A tibble with 47 observations and 8 variables:
\describe{
  \item{jis_code}{JIS code of the prefecture (character)}
  \item{prefecture}{Prefectural name in romaji (character)}
  \item{region}{Geographical region of the prefecture (factor)}
  \item{major_island}{Major island the prefecture belongs to (character)}
  \item{prefecture_kanji}{Prefectural name in kanji (character)}
  \item{region_kanji}{Region name in kanji (factor)}
  \item{x}{X coordinate for grid placement (integer)}
  \item{y}{Y coordinate for grid placement (integer)}
}
}
\source{
Data taken from the tabularmaps package version 0.1.0
}
\usage{
data(jpn_prefectures_tbl_df)
}
\description{
This dataset, jpn_prefectures_tbl_df, is a tibble representing Japan’s 47 prefectures
arranged in a 7x7 grid layout. It includes prefectural codes, names in both romaji and kanji,
regions, major islands, and grid coordinates.
}
\details{
The dataset name has been kept as 'jpn_prefectures_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
JapanAPIs package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not been modified
in any way.
}
