
#'
#' ThaiData
#' 
#' ThaiData is the raw data of the DNE variables obtained from the Southeast Asian 
#' sample to develop the A_PCR and M_PCR models. It consists of Age, MeanDNE.Apex, MedianDNE.Apex, IQRDNE.Apex, TotalDNE.TotalPolygonFaces, MedianDNE.Whole, IQRDNE.Whole, MeanDNE.Convex, MeanDNE.Concave, Proportion.DNEunder0.0001, Proportion.DNEover0.6, PCQDA_Estimated (results of PCQDA model) and PCR_pred (results of PCR model) , PCLR_pred (results of PCLR model).
#' 
#' @export
#' 
ThaiData<-{
  Age <- c(28, 39, 36, 35, 36, 22, 55, 22, 39, 22, 74, 37, 28, 59, 33, 49, 45, 35, 36, 39, 36, 23, 52, 76, 55, 39, 39, 61, 90, 35, 44, 61, 53, 75, 64, 70, 38, 36, 76, 54, 72, 67, 38, 65, 23, 67, 51, 49, 44, 38, 40, 90, 70, 59, 37, 61, 39, 37, 75, 35, 57, 62, 62, 45, 64, 66, 75, 71, 52, 73, 36, 34, 49, 40, 55, 55, 42, 40, 66, 54, 61, 29, 32, 46, 37, 72, 63, 55, 41, 40, 38, 53, 68, 85, 67, 57, 77, 50, 37, 47, 74, 42, 67, 61, 42, 44, 49, 45, 77, 63, 55, 37, 40, 68, 76, 75, 29, 30, 60, 57, 26, 70, 47, 41, 23, 78, 78, 25, 53, 57, 64, 34, 64, 81, 33, 56, 60, 40, 53, 68, 59, 32, 73, 72, 33, 54, 59, 66, 50, 51, 67, 65, 42, 59, 63, 75, 77, 37, 56, 25, 55, 91, 47, 84, 91, 71, 40, 30, 85, 34, 24, 40, 39, 30, 72, 49, 86, 37, 52, 
           66, 74, 72, 42, 47, 34, 26, 38, 64, 61, 77, 64, 49, 53, 57, 75, 39, 34, 87, 52, 32, 44, 64, 51, 66, 40, 51, 48, 91, 43, 59, 67, 40, 75, 51, 53, 60, 51, 66, 30, 55, 71, 75, 37, 65, 75, 93, 73, 55, 22, 76, 68, 72, 65, 40, 60, 24, 46, 86, 38, 39, 75, 34, 69, 72, 43, 37, 56, 36, 64, 56, 40, 57, 61, 39, 36, 58, 68, 40, 40, 32, 54, 54, 64, 75, 53, 88, 42, 68, 22, 64, 48, 65, 52, 48, 65, 22, 40, 42, 65, 33, 54, 49, 45, 66, 77, 68, 34, 72, 72, 44, 91, 91, 40, 66, 78, 42, 40, 40, 34, 44, 50, 39, 55, 88, 75, 50, 23, 64, 57, 54, 72, 83, 40, 72, 79, 91, 78, 78, 70, 44, 49, 78, 56, 77, 70, 70, 44, 81, 58, 80, 72, 86, 70, 64, 57)
  MeanDNE.Apex <- c(0.019749, 0.021767, 0.022953, 0.023995, 0.023516, 0.033347, 0.045844, 0.024343, 0.03489, 0.015239, 0.036567, 0.023417, 0.023334, 0.018494, 0.026939, 0.028056, 0.031663, 0.027673, 0.034076, 0.025793, 0.029901, 0.013509, 0.022226, 0.040856, 0.023107, 0.023071, 0.03095, 0.05092, 0.047679, 0.018172, 0.024185, 0.048011, 0.042028, 0.048182, 0.052017, 0.023334, 0.017038, 0.023275, 0.036558, 0.044853, 0.051714, 0.036903, 0.020974, 0.030886, 0.019262, 0.028185, 0.015272, 0.041337, 0.030809, 0.023453, 0.031351, 0.051222, 0.049346, 0.045345, 0.023448, 0.035103, 0.028665, 0.02558, 0.043822, 0.029175, 0.027732, 0.043377, 0.045962, 0.0369, 0.057454, 0.031606, 0.040569, 0.031885, 0.034844, 0.03978, 0.027327, 0.025391, 0.036842, 0.029884, 0.028296, 0.025106, 0.037081, 0.029293, 0.048006, 
                    0.042238, 0.038529, 0.021691, 0.028146, 0.033785, 0.032947, 0.055236, 0.051302, 0.032936, 0.035083, 0.016752, 0.029912, 0.039239, 0.049137, 0.053222, 0.036637, 0.032798, 0.022884, 0.034899, 0.027257, 0.041302, 0.035921, 0.041053, 0.039039, 0.02779, 0.028273, 0.028394, 0.027039, 0.03357, 0.059984, 0.043481, 0.033831, 0.029562, 0.030924, 0.054931, 0.02543, 0.05997, 0.019904, 0.032102, 0.044958, 0.024771, 0.019895, 0.053486, 0.038605, 0.033915, 0.023108, 0.042338, 0.035918, 0.022265, 0.038512, 0.026047, 0.043487, 0.02438, 0.040557, 0.051377, 0.021836, 0.032637, 0.027304, 0.026162, 0.034146, 0.042166, 0.043266, 0.023823, 0.048574, 0.05106, 0.023789, 0.021447, 0.03463, 0.050648, 0.03758, 0.031937, 0.035961, 0.048728, 0.031268, 0.035885, 0.049681, 0.028316, 0.051015, 0.027496, 0.038333, 0.020069, 0.041794, 0.067757, 
                    0.036005, 0.038872, 0.036377, 0.038958, 0.027917, 0.023005, 0.051102, 0.023396, 0.025203, 0.025401, 0.020008, 0.02504, 0.019429, 0.047902, 0.042696, 0.026048, 0.027951, 0.039909, 0.047303, 0.043896, 0.018362, 0.032144, 0.029438, 0.026556, 0.02874, 0.044916, 0.022581, 0.02789, 0.038691, 0.03138, 0.046295, 0.032756, 0.034225, 0.029278, 0.025854, 0.034966, 0.025777, 0.017338, 0.017798, 0.03518, 0.041574, 0.041098, 0.034556, 0.043811, 0.033335, 0.064991, 0.031196, 0.021556, 0.034501, 0.032804, 0.032237, 0.031932, 0.034402, 0.031604, 0.018524, 0.023359, 0.028022, 0.040106, 0.040072, 0.056324, 0.024474, 0.033932, 0.039892, 0.063957, 0.042234, 0.030919, 0.025034, 0.039671, 0.029492, 0.034461, 0.045663, 0.025431, 0.042266, 0.019199, 0.03365, 0.054075, 0.025477, 0.030747, 0.018083, 0.024511, 0.036925, 0.045451, 0.034202, 0.022482, 0.033383, 0.021922, 0.023238, 0.039395, 0.029173, 0.045486, 
                    0.022439, 0.018368, 0.019868, 0.037397, 0.038736, 0.030047, 0.030955, 0.025187, 0.038187, 0.034879, 0.020146, 0.020839, 0.015311, 0.044911, 0.044884, 0.014797, 0.031652, 0.03695, 0.028331, 0.039444, 0.044382, 0.024561, 0.033896, 0.025269, 0.016596, 0.045781, 0.03689, 0.027248, 0.023661, 0.021587, 0.032037, 0.040078, 0.046023, 0.019428, 0.030148, 0.029768, 0.026811, 0.030801, 0.048889, 0.05229, 0.033996, 0.020864, 0.053001, 0.022461, 0.03114, 0.031659, 0.018228, 0.034402, 0.036113, 0.028026, 0.047909, 0.059583, 0.040782, 0.034428, 0.020554, 0.028363, 0.033857, 0.030255, 0.04488, 0.046978, 0.03269, 0.045101, 0.031673, 0.058889, 0.045302, 0.046598, 0.043104, 0.04093, 0.031408, 0.037509, 0.032406, 0.040365, 0.03225, 0.039272, 0.038077, 0.045573, 0.028489, 0.048956, 0.037939, 0.050943, 0.058266, 0.032142, 0.033738)
  MedianDNE.Apex <- c(0.004763, 0.01049, 0.010221, 0.005629, 0.006268, 0.006146, 0.013647, 0.008214, 0.012682, 0.002086, 0.014487, 0.006369, 0.00539, 0.019736, 0.004055, 0.015704, 0.015571, 0.004549, 0.004017, 0.010822, 0.009305, 0.004026, 0.014556, 0.017982, 0.010292, 0.00907, 0.007396, 0.015398, 0.019931, 0.006622, 0.008618, 0.016654, 0.018103, 0.008437, 0.014952, 0.007244, 0.005892, 0.007415, 0.014578, 0.007703, 0.010375, 0.013014, 0.008186, 0.015399, 0.004725, 0.012994, 0.010459, 0.018015, 0.015444, 0.005311, 0.008864, 0.016823, 0.011017, 0.013505, 0.007643, 0.015956, 0.014853, 0.007983, 0.010126, 0.002733, 0.010473, 0.012549, 0.014504, 0.010204, 0.019061, 0.017333, 0.013257, 0.014229, 0.008103, 0.010256, 0.004027, 0.003342, 0.008441, 0.012952, 0.019289, 0.007632, 0.013066, 0.011762, 0.01805, 0.010459, 0.007991, 0.003719, 0.007788, 0.009416, 0.010469, 0.009761, 0.017404, 0.0173, 0.012994, 0.008156, 0.010353, 0.017919, 0.021453, 0.01007, 0.02134, 
                      0.014062, 0.014356, 0.007674, 0.010468, 0.021121, 0.020193, 0.013132, 0.009243, 0.011095, 0.018441, 0.018738, 0.020898, 0.01039, 0.020558, 0.016405, 0.013471, 0.007866, 0.009855, 0.014776, 0.012332, 0.016021, 0.00517, 0.005199, 0.011023, 0.018448, 0.002588, 0.019685, 0.008135, 0.009919, 0.002738, 0.024003, 0.015308, 0.002328, 0.020248, 0.015103, 0.012077, 0.005289, 0.021421, 0.019207, 0.004081, 0.010314, 0.01253, 0.009258, 0.017067, 0.016521, 0.015323, 0.007326, 0.014779, 0.020364, 0.006217, 0.010233, 0.009601, 0.024632, 0.012789, 0.016254, 0.008348, 0.009699, 0.014863, 0.020521, 0.011993, 0.012832, 0.011739, 0.009009, 0.011541, 0.003047, 0.009022, 0.017616, 0.008116, 0.019071, 0.017189, 0.021009, 0.012993, 0.003805, 0.011478, 0.008084, 0.003106, 0.007943, 0.007003, 0.006004, 0.017168, 0.019265, 0.016653, 0.006078, 0.019149, 0.009328, 0.02344, 0.013909, 0.016915, 0.019733, 0.007423, 0.004206, 0.010448, 0.012975, 0.011866, 0.015104, 0.010329, 0.014042, 
                      0.009042, 0.019635, 0.016597, 0.008142, 0.008047, 0.014415, 0.006913, 0.004134, 0.016589, 0.010195, 0.015113, 0.02196, 0.010131, 0.00639, 0.009105, 0.017244, 0.011098, 0.011645, 0.016791, 0.010513, 0.018561, 0.017493, 0.015269, 0.017246, 0.010451, 0.009284, 0.007962, 0.011631, 0.017835, 0.010487, 0.007887, 0.020944, 0.015617, 0.018609, 0.011536, 0.008247, 0.002866, 0.023965, 0.015813, 0.015587, 0.019123, 0.014086, 0.01428, 0.001816, 0.008865, 0.017022, 0.005919, 0.010358, 0.01935, 0.009434, 0.012062, 0.010514, 0.006506, 0.007146, 0.008559, 0.006334, 0.018663, 0.00846, 0.016974, 0.016134, 0.009931, 0.011424, 0.009468, 0.00946, 0.010541, 0.009291, 0.018552, 0.004134, 0.010991, 0.008437, 0.010954, 0.010747, 0.016084, 0.014024, 0.017596, 0.010811, 0.00303, 0.013032, 0.009814, 0.014291, 0.010846, 0.01061, 0.011472, 0.008348, 0.016206, 0.012673, 0.010925, 0.008223, 0.009423, 0.012236, 0.01352, 
                      0.011198, 0.012106, 0.009284, 0.005881, 0.021797, 0.022421, 0.007449, 0.013816, 0.022836, 0.01725, 0.012316, 0.021236, 0.016674, 0.010132, 0.012759, 0.010137, 0.008646, 0.013632, 0.015917, 0.009734, 0.014933, 0.015467, 0.010082, 0.00354, 0.008844, 0.010917, 0.009435, 0.019247, 0.014751, 0.010119, 0.012192, 0.017717, 0.020165, 0.01378, 0.019368, 0.011, 0.018566, 0.010039, 0.013585, 0.010635, 0.023728, 0.008882, 0.008961, 0.018493, 0.020211, 0.010543, 0.016836, 0.00827, 0.020813, 0.016182, 0.019697, 0.011785)
  IQRDNE.Apex <- c(0.013023, 0.0172, 0.018973, 0.015607, 0.017922, 0.019181, 0.032133, 0.022124, 0.022901, 0.011582, 0.035078, 0.014579, 0.015076, 0.016932, 0.014859, 0.020099, 0.025293, 0.018136, 0.017261, 0.019877, 0.017067, 0.009539, 0.020643, 0.034101, 0.030798, 0.015649, 0.01622, 0.042665, 0.041014, 0.01618, 0.02016, 0.041422, 0.026337, 0.024942, 0.028654, 0.027679, 0.016265, 0.014314, 0.03656, 0.027865, 0.031887, 0.030573, 0.015623, 0.031384, 0.016585, 0.031238, 0.035312, 0.024229, 0.024878, 0.015106, 0.017458, 0.035713, 0.026056, 0.031615, 0.012156, 0.026645, 0.024867, 0.013912, 0.026758, 0.017635, 0.020736, 0.025706, 
                   0.027778, 0.026664, 0.037567, 0.027396, 0.02576, 0.037278, 0.026243, 0.025937, 0.01215, 0.023493, 0.017855, 0.026737, 0.035791, 0.021571, 0.024532, 0.020848, 0.023413, 0.025186, 0.024024, 0.018226, 0.021762, 0.022426, 0.020554, 0.025902, 0.039511, 0.030988, 0.029904, 0.022079, 0.017524, 0.040511, 0.034456, 0.038987, 0.022483, 0.022318, 0.045187, 0.03205, 0.017221, 0.035817, 0.044737, 0.021857, 0.034147, 0.023289, 0.023993, 0.017498, 0.031003, 0.020599, 0.036797, 0.030255, 0.024292, 0.016236, 0.025068, 0.037151, 0.028784, 0.031279, 0.014587, 0.020172, 0.032722, 0.031741, 0.015013, 0.046078, 0.028194, 0.025626, 0.016796, 0.031061, 0.039149, 0.016217, 0.026018, 0.030674, 0.040329, 0.020199, 0.04258, 0.03922, 0.021601, 0.033936, 0.033698, 0.022443, 0.037443, 0.016001, 0.018502, 0.01566, 
                   0.025892, 0.031569, 0.01653, 0.036425, 0.041269, 0.042042, 0.03465, 0.033305, 0.031512, 0.025684, 0.023352, 0.02458, 0.03541, 0.02141, 0.026978, 0.018061, 0.022396, 0.014972, 0.021068, 0.032081, 0.021023, 0.032716, 0.030249, 0.044545, 0.020626, 0.014807, 0.038948, 0.017133, 0.014981, 0.024964, 0.016607, 0.016765, 0.034857, 0.026839, 0.034285, 0.024403, 0.030815, 0.024794, 0.040896, 0.03367, 0.021093, 0.03395, 0.019446, 0.016253, 0.017967, 0.016012, 0.029834, 0.03849, 0.040947, 0.024094, 0.033183, 0.025673, 0.018096, 0.017738, 0.013489, 0.029493, 0.021764, 0.016453, 0.023, 0.029732, 0.04094, 0.043366, 0.027326, 0.024488, 0.024195, 0.027651, 0.022612, 0.020302, 0.027165, 0.022116, 0.023522, 0.021035, 0.031502, 0.039358, 0.033764, 0.027756, 0.014148, 0.021132, 0.037429, 0.031582, 0.021844, 0.027813, 
                   0.034619, 0.042335, 0.027858, 0.015015, 0.022687, 0.028198, 0.017851, 0.028055, 0.028178, 0.025441, 0.031456, 0.014475, 0.021513, 0.027394, 0.015577, 0.018029, 0.022976, 0.018132, 0.03236, 0.031039, 0.018191, 0.015603, 0.034076, 0.019886, 0.031026, 0.034589, 0.020895, 0.030524, 0.036165, 0.016071, 0.021958, 0.020272, 0.028149, 0.02379, 0.023082, 0.024768, 0.033364, 0.018445, 0.028563, 0.025138, 0.020395, 0.040764, 0.016691, 0.025357, 0.018456, 0.034172, 0.018345, 0.034639, 0.026878, 0.025781, 0.029887, 0.016262, 0.024484, 0.023194, 0.029337, 0.017601, 0.019117, 0.022179, 0.020686, 0.033043, 0.023661, 0.031426, 0.015624, 0.040691, 0.02901, 0.030176, 0.045758, 0.043256, 0.01687, 0.034107, 0.025813, 0.022559, 0.023906, 0.022613, 0.015651, 0.022101, 0.034693, 0.019845, 0.028339, 0.036249, 0.024506, 
                   0.031452, 0.014957, 0.031466, 0.022335, 0.021707, 0.031215, 0.041752, 0.018382, 0.032362, 0.024193, 0.03991, 0.04345, 0.029153, 0.032177, 0.036874, 0.026915, 0.040177, 0.025895, 0.03605, 0.024615, 0.04217, 0.031394, 0.05424, 0.017659, 0.039111, 0.018593, 0.04609, 0.040032, 0.028277, 0.039587)
  TotalDNE.TotalPolygonFaces <- c(0.005891, 0.025525, 0.003856, 0.016405, 0.020706, 0.006252, 0.020704, 0.013529, 0.005404, 0.0071, 0.042845, 0.006327, 0.008151, 0.023392, 0.011259, 0.021069, 0.021808, 0.020723, 0.016674, 0.021462, 0.016231, 0.012751, 0.019048, 0.040965, 0.017746, 0.013443, 0.024452, 0.035175, 0.04419, 0.006449, 0.018316, 0.027194, 0.02063, 0.015006, 0.025703, 0.026731, 0.016517, 0.007944, 0.028904, 0.021558, 0.04503, 0.026159, 0.024366, 0.017308, 0.010276, 0.017933, 0.020111, 0.021924, 0.01794, 0.020646, 0.019346, 0.047067, 0.016724, 0.016276, 0.012965, 0.017171, 0.007615, 0.008156, 0.02802, 0.02051, 0.017421, 0.024821, 0.021051, 0.022521, 0.018881, 0.026291, 0.019027, 0.019861, 0.017698, 0.028318, 0.024024, 0.01921, 0.013212, 0.018586, 0.024696, 0.028585, 0.017022, 0.019607, 0.03506, 0.013861, 0.020879, 0.01138, 0.005445, 0.022306, 0.018394, 0.031761, 0.023105, 0.023181, 0.018809, 
                                  0.023987, 0.014625, 0.023586, 0.020435, 0.035632, 0.027946, 0.015176, 0.021576, 0.014906, 0.008585, 0.018432, 0.038178, 0.009178, 0.024041, 0.021606, 0.019745, 0.025849, 0.02338, 0.01868, 0.019041, 0.031949, 0.022047, 0.020169, 0.015123, 0.031341, 0.02891, 0.021746, 0.017543, 0.02456, 0.023457, 0.022558, 0.009855, 0.018761, 0.018388, 0.015196, 0.01537, 0.03409, 0.031142, 0.012995, 0.015837, 0.024099, 0.0261, 0.019373, 0.021717, 0.041644, 0.021051, 0.022576, 0.027669, 0.00925, 0.01999, 0.029017, 0.022468, 0.007748, 0.019858, 0.023293, 0.020676, 0.019467, 0.024996, 0.015086, 0.01862, 0.020714, 0.022017, 0.005321, 0.022073, 0.029255, 0.014664, 0.044709, 0.023778, 0.020889, 0.023887, 0.018234, 0.020399, 0.037988, 0.02116, 0.020316, 0.042967, 0.023411, 0.019776, 0.01237, 0.037647, 0.007556, 0.010017, 0.023014, 0.009794, 0.020454, 0.016975, 0.020851, 0.033538, 0.025627, 0.029512, 0.023617, 0.023119, 0.022833, 0.026525, 0.02158, 0.013634, 0.01418, 0.011224, 0.008533, 0.02473, 0.024175, 0.024615, 
                                  0.021317, 0.02122, 0.019655, 0.02702, 0.007625, 0.010341, 0.025351, 0.020705, 0.01121, 0.019831, 0.021342, 0.022602, 0.023498, 0.020383, 0.018017, 0.021183, 0.026846, 0.022417, 0.032485, 0.026256, 0.0263, 0.028073, 0.027182, 0.022016, 0.008616, 0.023056, 0.025374, 0.007288, 0.030867, 0.023441, 0.017558, 0.026345, 0.021601, 0.026614, 0.046261, 0.023227, 0.02481, 0.018144, 0.023386, 0.023901, 0.035988, 0.021321, 0.02462, 0.034068, 0.005413, 0.010132, 0.045152, 0.010231, 0.025547, 0.02558, 0.00962, 0.024937, 0.025301, 0.020915, 0.010276, 0.023246, 0.0103, 0.022457, 0.021141, 0.019465, 0.021737, 0.030198, 0.016696, 0.020463, 0.021143, 0.024835, 0.019726, 0.013409, 0.016697, 0.024302, 0.023905, 0.026569, 0.030647, 0.010261, 0.037833, 0.020395, 0.013183, 0.020804, 0.0241, 0.022106, 0.022314, 0.024681, 0.023262, 0.023447, 0.010309, 0.021041, 0.02486, 0.028631, 0.017374, 0.0241, 0.025043, 
                                  0.01373, 0.010535, 0.036887, 0.026317, 0.008212, 0.02945, 0.041543, 0.015788, 0.049159, 0.047493, 0.020811, 0.024783, 0.026846, 0.014197, 0.021641, 0.01105, 0.022137, 0.01253, 0.021629, 0.017602, 0.026213, 0.038935, 0.026255, 0.025295, 0.008285, 0.027821, 0.025735, 0.023698, 0.037606, 0.029461, 0.024637, 0.011791, 0.029197, 0.052655, 0.025249, 0.035643, 0.040524, 0.030022, 0.023834, 0.030864, 0.024651, 0.029327, 0.03736, 0.031123, 0.028594, 0.036279, 0.027583, 0.034663, 0.033072, 0.037826, 0.033858, 0.031069, 0.027075)
  
  MedianDNE.Whole <- c(0.00241, 0.010605, 0.005562, 0.005214, 0.008057, 0.004163, 0.008655, 0.005258, 0.007757, 0.010567, 0.012293, 0.007573, 0.004286, 0.005199, 0.006434, 0.008982, 0.006492, 0.006629, 0.007465, 0.002708, 0.009039, 0.007416, 0.00493, 0.012346, 0.011892, 0.002682, 0.005922, 0.009133, 0.01346, 0.004344, 0.009408, 0.009333, 0.006851, 0.008078, 0.009905, 0.004602, 0.00539, 0.006102, 0.011925, 0.007051, 0.015297, 0.005763, 0.00874, 0.008861, 0.005235, 0.008693, 0.014027, 0.009429, 0.006442, 0.009888, 0.007913, 0.010981, 0.005426, 0.004176, 0.009557, 0.009874, 0.009212, 0.009949, 0.015133, 0.003054, 0.010276, 0.011738, 0.013742, 0.00417, 0.009466, 0.007882, 0.011616, 0.008315, 0.004991, 0.01149, 0.005094, 0.008632, 0.006912, 0.009935, 0.005609, 0.005745, 0.012718, 0.00895, 0.006883, 0.010676, 0.011336, 0.005595, 0.004626, 0.005581, 0.00759, 0.004308, 0.01209, 0.010418, 0.006569, 0.010124, 0.006846, 0.011688, 0.014061, 0.015997, 0.009766, 0.011818, 0.013978, 0.007848, 0.009064, 
                       0.007189, 0.011775, 0.008704, 0.007768, 0.010514, 0.010734, 0.007558, 0.003335, 0.005596, 0.012394, 0.007296, 0.008571, 0.007081, 0.004559, 0.012689, 0.011542, 0.006296, 0.002925, 0.00309, 0.011451, 0.010743, 0.004263, 0.014869, 0.01137, 0.004174, 0.006905, 0.009323, 0.010583, 0.004463, 0.009557, 0.004677, 0.013826, 0.006309, 0.014225, 0.012388, 0.004514, 0.007764, 0.010751, 0.004669, 0.007061, 0.008473, 0.012036, 0.002132, 0.009293, 0.011512, 0.00412, 0.010368, 0.012445, 0.010338, 0.005483, 0.011969, 0.011579, 0.010107, 0.007793, 0.009308, 0.010723, 0.011481, 0.012951, 0.006194, 0.013044, 0.005573, 0.004072, 0.012051, 0.010221, 0.013764, 0.01239, 0.010082, 0.004264, 0.002973, 0.011098, 0.005274, 0.006488, 0.004316, 0.005931, 0.006763, 0.009154, 0.005359, 0.013527, 0.008235, 0.006334, 0.011055, 0.011953, 0.011517, 0.004513, 0.005546, 0.006476, 0.007009, 0.005287, 
                       0.008239, 0.011503, 0.007756, 0.013455, 0.00768, 0.004043, 0.008134, 0.011762, 0.009901, 0.004529, 0.007946, 0.00583, 0.004149, 0.004856, 0.012693, 0.007005, 0.015057, 0.004382, 0.006661, 0.005509, 0.017589, 0.004506, 0.010032, 0.007186, 0.005967, 0.003815, 0.011135, 0.003885, 0.006384, 0.006655, 0.009906, 0.005336, 0.007663, 0.010924, 0.009872, 0.00528, 0.008773, 0.011728, 0.013927, 0.010573, 0.007312, 0.00265, 0.009951, 0.011985, 0.015235, 0.007698, 0.004395, 0.010258, 0.004247, 0.004767, 0.009536, 0.004167, 0.005261, 0.006907, 0.004673, 0.011463, 0.010151, 0.004506, 0.002708, 0.011848, 0.00306, 0.01276, 0.007199, 0.006998, 0.009055, 0.011634, 0.00207, 0.002032, 0.006937, 0.012605, 0.004239, 0.007414, 0.00761, 0.012523, 0.005674, 0.009354, 0.009905, 0.006899, 0.009773, 0.004533, 0.00649, 0.008562, 
                       0.007701, 0.0033, 0.014539, 0.006898, 0.004685, 0.014141, 0.005107, 0.002552, 0.002532, 0.010836, 0.005795, 0.009682, 0.005195, 0.005089, 0.008768, 0.004691, 0.007731, 0.004125, 0.007243, 0.006197, 0.0061, 0.015607, 0.00967, 0.00835, 0.004969, 0.014117, 0.006594, 0.008234, 0.004243, 0.006719, 0.004649, 0.002698, 0.008644, 0.007375, 0.011495, 0.011272, 0.005838, 0.004992, 0.010477, 0.007179, 0.008563, 0.011555, 0.012406, 0.009657, 0.011565, 0.014882, 0.01225, 0.010888, 0.01354, 0.010476, 0.007131, 0.0059, 0.012192, 0.009299, 0.009655, 0.010784, 0.00836, 0.01386, 0.014609, 0.003595, 0.010668, 0.014046, 0.010095, 0.012555, 0.006185, 0.011425)
  IQRDNE.Whole <- c(0.007612, 0.011255, 0.010722, 0.010905, 0.007608, 0.011803, 0.025366, 0.00714, 0.01215, 0.005213, 0.017966, 0.016163, 0.009494, 0.025767, 0.00871, 0.013404, 0.006609, 0.020344, 0.018616, 0.00487, 0.015172, 0.0132, 0.018097, 0.028706, 0.021749, 0.005913, 0.00692, 0.029267, 0.032442, 0.015626, 0.015042, 0.014327, 0.017963, 0.029219, 0.02718, 0.024298, 0.009053, 0.012476, 0.027758, 0.01781, 0.027465, 0.032246, 0.009231, 0.02439, 0.006966, 0.018551, 0.018365, 0.014955, 0.014349, 0.006156, 0.006785, 
                    0.032504, 0.02685, 0.021784, 0.009304, 0.019979, 0.00938, 0.005351, 0.01992, 0.01019, 0.02466, 0.023059, 0.023059, 0.021072, 0.029369, 0.023179, 0.022095, 0.030955, 0.020729, 0.026448, 0.010336, 0.010708, 0.014281, 0.012235, 0.008736, 0.017744, 0.022037, 0.012421, 0.023184, 0.017937, 0.027241, 0.009043, 0.007518, 0.011565, 0.006442, 0.02663, 0.027843, 0.017777, 0.012546, 0.012764, 0.020645, 0.012553, 0.019703, 0.031342, 0.026011, 0.027442, 0.020694, 0.01116, 0.010957, 0.011725, 0.030284, 0.012426, 0.021013, 0.024877, 0.012726, 0.020508, 0.00663, 0.012317, 0.014021, 0.022896, 0.017831, 0.011319, 0.013299, 0.027987, 0.026932, 0.02147, 0.00777, 0.016242, 0.022425, 0.010497, 0.009416, 0.020035, 0.012266, 0.025327, 0.011022, 0.025636, 0.023777, 0.008735, 0.021226, 0.013957, 0.023725, 0.012336, 0.023725, 0.031057, 0.016615, 0.01772, 0.021519, 0.013975, 0.026274, 0.023849, 0.01811, 0.015864, 0.020802, 0.024646, 0.015057, 0.007118, 0.017242, 0.026431, 0.012683, 0.021659, 0.019028, 0.017556, 
                    0.007179, 0.017256, 0.022909, 0.02722, 0.017819, 0.015615, 0.02181, 0.009929, 0.011555, 0.041657, 0.013661, 0.024486, 0.03166, 0.026828, 0.014964, 0.014407, 0.031364, 0.014708, 0.010475, 0.017415, 0.019867, 0.008543, 0.021397, 0.028764, 0.030011, 0.01844, 0.015816, 0.023214, 0.027305, 0.026659, 0.01022, 0.014518, 0.019315, 0.011728, 0.018683, 0.023746, 0.0192, 0.027782, 0.02977, 0.014346, 0.020459, 0.025528, 0.023135, 0.0187, 0.019648, 0.024197, 0.026544, 0.009688, 0.017539, 0.021298, 0.020639, 0.023521, 0.011297, 0.018843, 0.014927, 0.024871, 0.010825, 0.026439, 0.015469, 0.016502, 0.031457, 0.009283, 0.016755, 0.020038, 0.012742, 0.02784, 0.010903, 0.019879, 0.027182, 0.014923, 0.014908, 0.01946, 0.027497, 0.035243, 0.021454, 
                    0.026912, 0.019951, 0.027366, 0.025254, 0.030691, 0.019988, 0.012417, 0.020917, 0.007833, 0.011497, 0.026807, 0.014259, 0.01309, 0.015839, 0.013901, 0.019578, 0.026573, 0.012411, 0.010974, 0.017635, 0.021165, 0.015469, 0.017704, 0.013028, 0.0246, 0.021409, 0.013139, 0.018199, 0.017541, 0.020161, 0.013286, 0.008244, 0.014006, 0.010536, 0.024536, 0.017528, 0.026743, 0.026875, 0.032395, 0.016173, 0.020684, 0.01767, 0.020558, 0.021181, 0.021526, 0.02344, 0.017902, 0.032493, 0.014034, 0.014382, 0.025985, 0.022002, 0.013157, 0.021093, 0.02397, 0.013683, 0.02693, 0.032521, 0.021631, 0.013344, 0.023696, 0.020714, 0.025696, 0.02918, 0.022188, 0.013444, 0.014823, 0.023285, 0.018642, 0.015856, 0.014885, 0.005681, 0.017915, 0.026916, 0.016489, 0.03019, 0.025875, 0.025407, 0.02553, 0.017824, 0.024408, 0.023908, 0.02161, 0.026414, 0.027537, 0.016989, 0.018152, 0.024435, 0.036971, 0.026281, 0.031468, 0.029251, 0.025058, 0.02549, 0.023187, 0.020346, 0.024167, 0.016379, 0.023688, 0.024412, 0.022341, 0.02187, 0.02453, 0.027012, 0.037298, 0.027214, 0.023045, 0.02006)
  MeanDNE.Convex <- c(0.012092, 0.012435, 0.013563, 0.015016, 0.017385, 0.01593, 0.016442, 0.01366, 0.015278, 0.012868, 0.019775, 0.021591, 0.014622, 0.017281, 0.017436, 0.016929, 0.015612, 0.017207, 0.016316, 0.017712, 0.020316, 0.010956, 0.021369, 0.020448, 0.020709, 0.012471, 0.016337, 0.021426, 0.027668, 0.020653, 0.018398, 0.021439, 0.014956, 0.021565, 0.020157, 0.021517, 0.018101, 0.016981, 0.016872, 0.015969, 0.017877, 0.027663, 0.017407, 0.018135, 0.015727, 0.024403, 0.018164, 0.016489, 0.013801, 0.01515, 0.020456, 0.029683, 0.020252, 0.017115, 0.018717, 0.021251, 0.014919, 0.017135, 0.021463, 0.016674, 0.01617, 0.02134, 0.018502, 0.014945, 0.023137, 0.020207, 0.020644, 0.021239, 0.017001, 0.01674, 0.021796, 0.013328, 0.018861, 0.020979, 0.013875, 0.020668, 0.018926, 0.016274, 0.020159, 0.017048, 0.023867, 0.012565, 0.018878, 0.019275, 0.016904, 0.017426, 0.021206, 0.019898, 0.015875, 0.014171, 0.016816, 0.021889, 0.022237, 0.025381, 0.020422, 
                      0.024531, 0.02303, 0.01704, 0.016752, 0.021079, 0.01982, 0.025195, 0.025414, 0.01849, 0.017464, 0.024728, 0.014362, 0.01787, 0.028183, 0.017136, 0.016795, 0.014609, 0.016379, 0.020501, 0.024055, 0.025936, 0.017104, 0.017616, 0.024742, 0.021254, 0.013965, 0.016294, 0.021907, 0.019172, 0.015969, 0.020287, 0.017167, 0.012886, 0.02062, 0.019277, 0.029381, 0.020296, 0.02015, 0.02553, 0.014809, 0.01653, 0.021603, 0.016644, 0.020605, 0.020215, 0.024514, 0.015313, 0.023358, 0.018532, 0.014828, 0.017528, 0.0205, 0.02406, 0.020574, 0.017207, 0.018654, 0.021198, 0.023157, 0.023254, 0.020894, 0.019647, 0.026618, 0.015406, 0.018285, 0.013971, 0.020766, 0.028451, 0.016364, 0.021788, 0.033171, 0.021429, 0.019741, 0.015178, 0.026394, 0.020351, 0.017258, 0.016557, 0.021617, 0.018623, 0.026661, 0.024026, 0.024174, 0.020729, 0.014932, 0.020243, 0.02049, 0.024076, 0.022037, 0.015267, 0.019411, 0.014692, 0.018215, 0.025391, 0.020101, 0.019337, 0.026371, 0.025629, 0.024234, 0.023219, 0.025277, 0.020396, 0.015868, 0.022692, 0.016216, 0.016815, 0.017502, 0.024098, 0.015333, 0.019961, 0.012373, 0.016395, 0.015536, 0.024348, 0.021875, 0.019014, 
                      0.029544, 0.018284, 0.022564, 0.019212, 0.021994, 0.02282, 0.020593, 0.027832, 0.014833, 0.018615, 0.020275, 0.020043, 0.02063, 0.020938, 0.021648, 0.029684, 0.020058, 0.024647, 0.010357, 0.022845, 0.020159, 0.029785, 0.029188, 0.016102, 0.01708, 0.014716, 0.020217, 0.032356, 0.020356, 0.020339, 0.02048, 0.01698, 0.021464, 0.028763, 0.019043, 0.02187, 0.017583, 0.019437, 0.019444, 0.01623, 0.015307, 0.02253, 0.02654, 0.020939, 0.018647, 0.014769, 0.021234, 0.018896, 0.020119, 0.020349, 0.02061, 0.023044, 0.021477, 0.020243, 0.018828, 0.028985, 0.020234, 0.025475, 0.020492, 0.022165, 0.016542, 0.024172, 0.017046, 0.018067, 0.023424, 0.019854, 0.017206, 0.017252, 0.020526, 0.013067, 0.021825, 0.021848, 0.020081, 0.021407, 0.028379, 0.024751, 0.014972, 0.024804, 0.023819, 0.022514, 0.028164, 0.036171, 0.021637, 0.020171, 0.02408, 0.016407, 0.015919, 0.020834, 0.015594, 0.018311, 0.019378, 0.019315, 0.022296, 0.02698, 0.023264, 0.018668, 0.01837, 0.019289, 0.020323, 0.018936, 0.020446, 0.029734, 0.016133, 0.022439, 0.025032, 0.030235, 0.023231, 0.026163, 0.02086, 0.017448, 0.019971, 0.023168, 0.018184, 0.01758, 0.026782, 0.024562, 0.019198, 0.024592, 0.017476, 0.027385, 0.024673, 0.028419, 0.021321, 0.016019, 0.017766)
  MeanDNE.Concave <- c(0.009558, 0.014469, 0.01475, 0.018855, 0.013588, 0.015024, 0.016665, 0.010862, 0.018665, 0.009581, 0.029816, 0.017894, 0.010692, 0.02022, 0.012492, 0.016392, 0.018468, 0.010812, 0.01316, 0.011033, 0.015437, 0.010883, 0.015469, 0.031396, 0.030798, 0.014084, 0.014466, 0.029079, 0.031712, 0.013901, 0.030405, 0.030863, 0.016253, 0.03168, 0.019141, 0.032122, 0.018356, 0.014389, 0.035, 0.016187, 0.01604, 0.030369, 0.014836, 0.021849, 0.010968, 0.018392, 0.017376, 0.024961, 0.028836, 0.01459, 0.019632, 0.031925, 0.032113, 0.018047, 0.014361, 0.02115, 0.01504, 0.015574, 0.031682, 0.015908, 0.019221, 0.025056, 0.026699, 0.015651, 0.029464, 0.014556, 0.031686, 0.018238, 0.017743, 0.031266, 0.02117, 0.015202, 
                       0.023128, 0.020907, 0.018743, 0.031797, 0.024506, 0.019966, 0.017999, 0.01339, 0.024986, 0.011434, 0.012233, 0.013084, 0.017358, 0.031304, 0.015654, 0.025034, 0.024963, 0.022598, 0.023586, 0.015646, 0.031014, 0.031858, 0.032005, 0.02727, 0.030255, 0.01643, 0.015504, 0.017843, 0.033992, 0.027306, 0.03591, 0.029743, 0.017581, 0.020739, 0.016042, 0.015972, 0.037323, 0.01873, 0.022897, 0.015736, 0.01711, 0.029347, 0.031436, 0.018576, 0.013745, 0.012662, 0.031839, 0.028724, 0.011386, 0.020547, 0.01592, 0.024818, 0.015813, 0.027611, 0.018876, 0.010081, 0.012528, 0.024508, 0.024368, 0.020288, 0.028014, 0.029177, 0.015078, 0.021756, 0.02551, 0.021134, 0.015513, 0.021723, 0.018781, 0.017335, 0.020975, 0.023775, 0.015879, 0.021382, 0.021926, 0.032318, 0.026206, 0.016036, 0.029073, 0.02574, 0.030506, 0.027857, 0.021046, 0.03171, 0.015798, 0.017483, 0.015856, 0.010027, 0.020092, 0.030538, 0.023923, 0.027481, 0.036156, 0.02987, 0.021814, 0.015906, 0.031874, 0.016652, 0.017756, 0.017445, 0.013228, 
                       0.013369, 0.020893, 0.025357, 0.029769, 0.015128, 0.022697, 0.018882, 0.028574, 0.02739, 0.027692, 0.022889, 0.010928, 0.014176, 0.020603, 0.032297, 0.020431, 0.027911, 0.031823, 0.01762, 0.029327, 0.026218, 0.031605, 0.01472, 0.015792, 0.023425, 0.017219, 0.015145, 0.015755, 0.018405, 0.018113, 0.01889, 0.02586, 0.014323, 0.021688, 0.039702, 0.015827, 0.025289, 0.021683, 0.025279, 0.036989, 0.021598, 0.027355, 0.022568, 0.016153, 0.03575, 0.010308, 0.021251, 0.027637, 0.022289, 0.01744, 0.035858, 0.03058, 0.037204, 0.027073, 0.018814, 0.020545, 0.030413, 0.023885, 0.034892, 0.02868, 0.026799, 0.027343, 0.015658, 0.014409, 0.029948, 0.022641, 0.015362, 0.028544, 0.01303, 0.024564, 0.02875, 0.015739, 0.015538, 0.022536, 0.019176, 0.034198, 0.017346, 0.021636, 0.024155, 0.027402, 0.013177, 0.016018, 0.013543, 0.030507, 
                       0.020967, 0.020662, 0.015446, 0.023384, 0.02611, 0.029183, 0.014826, 0.017777, 0.028114, 0.023681, 0.032933, 0.017322, 0.030934, 0.02054, 0.030972, 0.024031, 0.014946, 0.014871, 0.017622, 0.022048, 0.020527, 0.034029, 0.014564, 0.017113, 0.023342, 0.021872, 0.025065, 0.0375, 0.027116, 0.015832, 0.030449, 0.035886, 0.020192, 0.02928, 0.043048, 0.016657, 0.021675, 0.029746, 0.021843, 0.021395, 0.022162, 0.017725, 0.019448, 0.024807, 0.020627, 0.019548, 0.029007, 0.032876, 0.019398, 0.012399, 0.031235, 0.022277, 0.020159, 0.032939, 0.027969, 0.02226, 0.018475, 0.033232, 0.03212, 0.02377, 0.025741, 0.032368, 0.024075, 0.027836, 0.037141, 0.023558, 0.034013, 0.014666, 0.031272, 0.02844, 0.034946, 0.01859, 0.033331, 0.036477, 0.035245, 0.032033, 0.026405, 0.017475)
  Proportion.DNEunder0.0001 <- c(0.007312, 0.007071, 0.006987, 0.007644, 0.005771, 0.007134, 0.003998, 0.008959, 0.007063, 0.009721, 0.004059, 0.009776, 0.006349, 0.004192, 0.009156, 0.006472, 0.005414, 0.007642, 0.006306, 0.007226, 0.007878, 0.009168, 0.004605, 0.002937, 0.003769, 0.009073, 0.008455, 0.005333, 0.003758, 0.008038, 0.005013, 0.004357, 0.003502, 0.00272, 0.004155, 0.00391, 0.005, 0.006904, 0.003094, 0.004496, 0.003653, 0.005067, 0.00777, 0.004298, 0.007964, 0.004242, 0.005918, 0.006288, 0.006744, 0.007306, 0.005093, 0.00463, 0.00352, 0.004923, 0.007284, 0.004752, 0.007787, 0.007364, 0.004275, 0.006818, 
                                 0.004955, 0.002988, 0.002916, 0.007211, 0.005302, 0.005773, 0.00427, 0.004179, 0.003449, 0.003512, 0.007053, 0.005416, 0.007179, 0.004852, 0.006927, 0.007059, 0.008466, 0.005193, 0.005497, 0.008392, 0.003885, 0.005258, 0.004913, 0.004224, 0.005997, 0.005877, 0.003985, 0.003552, 0.005133, 0.006837, 0.006476, 0.007322, 0.004671, 0.00431, 0.00336, 0.003772, 0.006782, 0.004631, 0.003273, 0.006032, 0.005043, 0.006413, 0.002747, 0.003262, 0.005919, 0.007333, 0.006981, 0.007565, 0.003516, 0.003849, 0.006412, 0.005317, 0.006914, 0.003561, 0.002677, 0.003855, 0.005775, 0.008222, 0.006287, 0.005655, 0.006678, 0.003741, 0.00477, 0.004896, 0.006973, 0.002737, 0.00277, 0.007623, 0.007097, 0.00624, 0.004036, 0.008645, 0.002989, 
                                 0.003148, 0.00762, 0.006432, 0.00434, 0.006296, 0.007154, 0.003787, 0.005642, 0.008848, 0.004645, 0.001471, 0.008131, 0.006807, 0.00708, 0.003792, 0.004365, 0.003503, 0.005562, 0.003216, 0.005355, 0.007438, 0.004236, 0.001995, 0.003204, 0.007247, 0.006058, 0.006332, 0.005293, 0.002944, 0.004328, 0.004224, 0.002437, 0.004962, 0.005006, 0.006254, 0.003581, 0.005916, 0.008929, 0.008031, 0.005351, 0.005399, 0.005203, 0.004872, 0.003749, 0.005239, 0.006129, 0.003689, 0.004607, 0.002142, 0.004551, 0.005579, 0.007597, 0.008322, 0.005619, 0.005966, 0.001817, 0.004797, 0.004002, 0.004704, 0.005884, 0.005415, 0.006053, 0.00537, 0.007073, 0.002478, 0.008685, 0.007301, 0.004339, 0.002419, 0.006594, 0.002912, 0.005722, 0.004789, 0.007821, 0.002073, 0.00419, 0.006508, 0.003167, 0.00547, 0.004668, 0.005634, 0.004125, 0.003578, 0.00521, 0.003302, 0.004879, 0.005903, 0.004704, 0.004695, 0.009209, 0.003582, 0.004729, 0.002539, 0.003414, 0.004903, 0.006096, 0.003824, 0.006501, 0.004757, 0.00295, 0.005946, 0.005527, 0.008017, 0.003011, 0.003916, 0.007324, 0.004872, 0.003703, 0.007017, 0.003085, 0.003807, 0.003546, 0.003787, 0.003232, 0.008893, 0.004738, 0.004832, 0.006397, 0.005368, 0.00303, 0.007223, 0.004906, 0.005211, 0.005914, 0.004043, 0.005146, 0.005846, 0.006111, 0.005609, 0.004349, 0.00352, 0.003035, 
                                 0.003192, 0.005061, 0.003942, 0.005073, 0.00149, 0.004862, 0.005584, 0.004391, 0.005099, 0.002331, 0.004059, 0.008946, 0.005063, 0.004512, 0.007008, 0.004157, 0.003897, 0.005123, 0.002189, 0.004149, 0.002582, 0.003113, 0.003432, 0.00288, 0.00456, 0.002949, 0.002104, 0.006759, 0.003513, 0.003148, 0.005064, 0.005396, 0.006356, 0.004169, 0.005505, 0.004895, 0.005038, 0.003164, 0.002865, 0.003354, 0.004867, 0.009951, 0.006787, 0.00454, 0.003169, 0.00312, 0.00493, 0.005748, 0.003135, 0.002699, 0.002488, 0.002524, 0.003892, 0.004799, 0.004435, 0.004818, 0.005108, 0.003144, 0.002984, 0.006253, 0.003014, 0.006982, 0.003432, 0.003054, 0.002331, 0.003206, 0.002548, 0.004318, 0.002529, 0.004994)
  Proportion.DNEover0.6 <- c(0.000496, 0.000415, 0.001618, 0.000483, 0.000451, 0.000742, 0.000706, 0.000247, 0.000489, 0.001009, 0.002175, 0.000532, 0.000689, 0.002024, 0.000378, 0.001245, 0.001495, 0.000927, 0.000907, 0.000729, 0.000727, 0.000157, 0.000464, 0.001608, 0.001773, 0.001033, 0.000925, 0.001009, 0.002045, 0.001028, 0.001621, 0.001221, 0.001717, 0.001515, 0.001743, 0.001979, 0.000759, 0.000501, 0.002118, 0.001988, 0.002214, 0.001073, 0.000438, 0.002818, 0.000435, 0.001866, 0.001087, 0.001823, 0.001693, 0.000491, 0.001167, 0.001464, 0.001731, 0.001453, 0.00053, 0.001283, 0.0017, 0.000846, 0.00202, 0.000521, 0.001869, 0.002413, 0.002153, 0.000609, 0.001584, 0.001182, 0.001553, 0.001195, 0.001353, 0.002174, 0.000451, 0.001485, 0.002479, 0.002058, 0.001474, 0.001842, 0.000636, 0.002257, 0.001989, 0.002031, 0.002933, 0.001057, 0.000596, 0.002218, 0.000904, 0.00237, 0.002321, 0.002198, 0.0015, 0.001834, 0.001687, 0.001906, 0.001273, 
                             0.002173, 0.000757, 0.001753, 0.002931, 0.0021, 0.000415, 0.000885, 0.003734, 0.001066, 0.002434, 0.002181, 0.000763, 0.001349, 0.001756, 0.001747, 0.001146, 0.00234, 0.001098, 0.000525, 0.001445, 0.002121, 0.002297, 0.001422, 0.000565, 0.001077, 0.001857, 0.001314, 0.000422, 0.001442, 0.001343, 0.001356, 0.000976, 0.003439, 0.002354, 0.000466, 0.000339, 0.002836, 0.001698, 0.000396, 0.001188, 0.001919, 0.001097, 0.001628, 0.003007, 0.001054, 0.001556, 0.00225, 0.002287, 0.000537, 0.001409, 0.003073, 0.001308, 0.001314, 0.001892, 0.000782, 0.001768, 0.001141, 0.002172, 0.002017, 0.000505, 0.001441, 0.001992, 0.00133, 0.001191, 0.002417, 0.001613, 0.000367, 0.001975, 0.004439, 0.001517, 0.001146, 0.004085, 0.002093, 0.001061, 0.000523, 0.002645, 0.000789, 0.001581, 0.001228, 0.000484, 0.00151, 0.001012, 0.001376, 0.002708, 0.000386, 0.001782, 0.002753, 0.002356, 0.002366, 0.001908, 0.001555, 0.000402, 0.000775, 0.000417, 0.002394, 0.002599, 0.003697, 0.001551, 0.001879, 0.002644, 0.001785, 0.003172, 0.000536, 0.001186, 0.001938, 0.001345, 0.00068, 0.000561, 0.002145, 0.002249, 0.002418, 0.001059, 0.001618, 0.001499, 
                             0.003586, 0.002618, 0.002309, 0.002763, 0.002664, 0.002392, 0.002747, 0.002205, 0.001418, 0.001632, 0.001379, 0.000552, 0.001654, 0.002369, 0.000755, 0.000515, 0.002778, 0.002454, 0.003344, 0.001819, 0.00211, 0.002184, 0.001507, 0.002143, 0.002664, 0.001493, 0.001058, 0.00131, 0.001007, 0.002547, 0.001261, 0.001403, 0.000448, 0.002305, 0.000472, 0.002172, 0.003271, 0.00139, 0.001013, 0.001559, 0.000478, 0.001551, 0.001602, 0.001596, 0.001482, 0.001828, 0.001847, 0.00113, 0.000533, 0.002132, 0.001471, 0.001443, 0.000837, 0.002, 0.00145, 0.002151, 0.002087, 
                             0.001724, 0.002575, 0.00183, 0.00149, 0.001852, 0.001771, 0.002304, 0.001933, 0.001558, 0.002308, 0.002075, 0.001081, 0.001699, 0.001438, 0.001987, 0.00045, 0.002423, 0.002453, 0.001384, 0.001956, 0.001665, 0.003264, 0.000515, 0.002263, 0.002326, 0.00136, 0.003163, 0.002192, 0.00156, 0.001054, 0.001603, 0.002309, 0.000703, 0.000891, 0.000693, 0.00199, 0.001341, 0.001338, 0.002395, 0.003088, 0.003063, 0.002662, 0.001168, 0.002496, 0.00145, 0.001529, 0.001482, 0.002415, 0.001707, 0.000825, 0.002347, 0.001801, 0.002141, 0.001092, 0.002923, 0.00126, 0.000805, 0.002375, 0.001656, 0.00208, 0.002511, 0.001962, 0.002234, 0.001652, 0.002006, 0.002332, 0.002167, 0.004038, 0.001785, 0.000744, 0.002058)
  PCQDA_Estimated <- c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 2, 1, 1, 1, 2, 3, 1, 3, 1, 2, 2, 1, 1, 1, 2, 2, 1, 2, 2, 2, 3, 3, 2, 3, 2, 2, 1, 3, 2, 2, 2, 2, 2, 1, 2, 2, 3, 2, 2, 2, 1, 2, 2, 2, 2, 3, 3, 2, 2, 2, 3, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 3, 3, 3, 2, 3, 3, 2, 3, 1, 2, 2, 2, 2, 3, 2, 2, 2, 3, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 3, 2, 3, 2, 3, 2, 2, 
                       2, 2, 3, 2, 3, 2, 2, 2, 2, 3, 3, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 3, 3, 3, 3, 2, 2, 2, 3, 2, 3, 3, 3, 2, 3, 3, 2, 2, 2, 2, 2, 3, 3, 2, 3, 3, 2, 3, 3, 3, 2, 3, 3, 2, 3, 2, 2, 2, 3, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 3, 2, 3, 2, 3, 3, 2, 2, 2, 3, 3, 3, 3, 3, 3, 2, 2, 3, 2, 3, 2, 3, 3, 2, 3, 2, 2, 3, 3, 3, 2, 3, 3, 3, 3, 3, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 3, 2, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 4, 4, 4, 4, 4, 4)
  PCR_pred <- c(15.79613077, 31.7466144, 33.77638984, 22.89108097, 45.78610574, 31.97761341, 29.04852422, 31.62190752, 26.18635792, 20.6168206, 37.16528105, 29.68270018, 30.20032853, 28.00989462, 33.35041487, 53.37760459, 51.78437831, 33.69121004, 34.57425432, 40.96649986, 38.66403777, 24.78342413, 37.80338233, 45.47050034, 49.56418419, 38.85821718, 35.85587913, 56.98413378, 38.56452967, 34.12373118, 32.54168563, 43.587961, 39.81395789, 45.04159416, 35.93161212, 34.88803642, 49.57674033, 34.90053267, 43.97462911, 43.28077362, 43.36278968, 51.82925525, 33.74199224, 38.57531388, 
                32.03761161, 44.73652129, 54.92919756, 45.11212077, 52.70091837, 34.44117577, 43.85932935, 48.48389373, 47.20396854, 47.15472573, 37.89482109, 49.64823929, 45.56111383, 40.8411325, 50.2449497, 45.6924971, 42.34803082, 53.43844994, 68.31703137, 47.4207917, 60.18345617, 43.15411536, 52.17317387, 43.27190187, 57.71244687, 54.37736586, 41.2125642, 43.24385164, 41.73817942, 43.364763, 40.11592177, 41.98235112, 48.63453264, 70.75717497, 51.57299513, 43.36389041, 50.97352366, 36.17369896, 47.71589361, 47.96161831, 46.51604013, 52.89102638, 62.02295728, 62.66922191, 44.30213751, 48.7367745, 44.14687312, 51.64143091, 53.77092094, 45.76819083, 51.2813258, 64.06202784, 42.4572971, 50.0661138, 43.20198386, 50.88606365, 50.39733814, 45.90591471, 61.5338832, 48.13309816, 51.98936654, 45.92584093, 58.3106828, 44.39327526, 64.97485264, 66.57580492, 64.55088394, 38.01424486, 54.40630459, 49.05962644, 46.58636629, 64.58016376, 38.20619368, 45.31851571, 52.28628963, 
                45.25448102, 52.01115507, 67.71875708, 62.63049645, 56.82875678, 48.16249595, 50.61898438, 50.39617251, 51.44734463, 57.95440171, 56.44725525, 55.81297217, 60.62607366, 58.74205755, 51.41613153, 41.58341062, 61.92257716, 48.42229875, 49.95630357, 49.60030058, 53.87042862, 46.06055837, 46.95167923, 60.85943706, 60.16698607, 57.41235084, 64.15467137, 57.18425416, 61.56389405, 61.21748352, 65.59396678, 52.80504009, 49.92208523, 57.49764742, 56.55512035, 60.48360685, 50.03045413, 61.86460038, 52.03808848, 49.19291106, 53.44081142, 57.57952675, 63.45810989, 68.92992575, 59.94380254, 54.04626968, 61.37463777, 66.01279866, 63.47259013, 50.85089101, 61.74374166, 46.33642818, 54.83239681, 50.52693996, 53.52148911, 60.12630763, 60.20230354, 66.72530346, 53.13013291, 46.89391172, 56.19201029, 65.85096204, 68.25601633, 71.54905045, 68.151435, 52.53550915, 50.09914066, 51.12851662, 53.63235523, 
                60.89219949, 58.63020404, 67.5312107, 66.51303919, 60.22897294, 68.08899642, 57.30409888, 54.57863679, 48.72333386, 48.51221584, 53.17922383, 55.26366747, 80.26721973, 63.05218514, 59.56757177, 60.66942622, 58.94449451, 60.20312546, 73.54661456, 60.62103606, 72.67946343, 56.75434013, 63.82768223, 68.17323133, 56.28856211, 78.11926089, 57.40005727, 58.21119861, 55.36602034, 65.63124061, 56.18678345, 53.8180833, 64.08402101, 55.26274846, 55.81661222, 73.78280402, 77.52541775, 64.84053043, 64.32522707, 59.29718815, 121.5168335, 90.05819827, 56.75431897, 61.47738067, 62.48513438, 65.3127869, 65.07739626, 48.10397058, 57.70521463, 61.97361328, 67.43426673, 64.60363586, 65.87640482, 61.77097201, 68.68360334, 74.75321796, 55.52435954, 
                63.44708098, 65.52630612, 59.53243608, 78.84330346, 64.36948189, 86.05710795, 66.21300523, 62.68314897, 81.01628347, 55.34344238, 59.91209658, 68.37374506, 73.44880367, 71.61340532, 61.82488921, 60.58579157, 61.58802555, 57.93809784, 69.49572781, 74.96256743, 60.62214487, 62.02147335, 61.88379618, 58.76406622, 73.78330892, 70.70428199, 73.40448677, 77.05325239, 65.88359944, 71.74875922, 67.26804565, 66.82479537, 64.95779917, 69.89767277, 62.83471004, 56.67195972, 77.15990583, 62.2577058, 72.82563236, 71.6492507, 75.13983849, 80.65191717, 80.83127591, 93.46316026, 71.56017879, 60.97959178, 58.39599428, 60.8519187, 80.43089453, 68.44604126, 75.50906467, 
                60.64382319, 66.97798464, 64.14156171, 71.74566056, 71.2983596, 70.58808555, 72.21500174, 77.24952666, 72.47923026, 79.94838396, 70.58630876, 73.30646578, 86.01439422, 68.20443489, 83.66478184, 85.69115452, 82.24731735, 85.40909086, 79.96894128, 66.50204092, 81.18294066, 69.59681147, 84.3549377, 77.36233228, 77.72772884, 80.7093259, 83.75169659, 98.46386091, 79.26166087, 95.86752319, 98.19881449, 109.4232446, 77.85063073, 92.65780711, 90.61914974, 104.9014362, 106.0144836, 122.0253474, 118.0203528)
  PCLR_pred <- c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 
                 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 2, 1, 2, 2, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2)
  ThaiData <- data.frame(Age, MeanDNE.Apex, MedianDNE.Apex, IQRDNE.Apex, TotalDNE.TotalPolygonFaces, MedianDNE.Whole, IQRDNE.Whole, MeanDNE.Convex, MeanDNE.Concave, Proportion.DNEunder0.0001, Proportion.DNEover0.6, PCQDA_Estimated, PCR_pred, PCLR_pred)
  ThaiData
}

#' @examples 
#' ThaiData