% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slm.R
\name{slm}
\alias{slm}
\title{Simple Longitudinal Mean (SLM)}
\usage{
slm(data, subject_id, time, response, k = 2, verbose = FALSE)
}
\arguments{
\item{data}{A data frame containing longitudinal data.}

\item{subject_id}{A column specifying the column name representing subject identifiers.}

\item{time}{A column specifying different time points that observations are measured.}

\item{response}{A column specifying the column name representing response values.}

\item{k}{A numeric value representing the threshold (number of standard deviations from the mean)
to classify a subject as influential.}

\item{verbose}{Logical; if TRUE, prints informative messages during execution.}
}
\value{
A list containing:
\item{influential_subjects}{A vector of subject IDs identified as influential.}
\item{influential_data}{A data frame containing data for influential subjects.}
\item{non_influential_data}{A data frame containing data for non-influential subjects.}
\item{influence_scores}{A data frame with subject IDs, mean response, IS (Influence Score), and PIS (Proportional Influence Score).}
\item{mean_plot}{A ggplot object showing mean responses per subject with influential subjects highlighted.}
\item{longitudinal_plot}{A ggplot object visualizing longitudinal response trends, with influential subjects highlighted.}
\item{IS_table}{A data frame containing the Influence Score (IS) and the Partial Influence Score (PIS) values for each subject.}
}
\description{
This function detects influential subjects in longitudinal data based on their mean response values.
It identifies subjects whose mean response deviates significantly beyond a specified threshold
(defined as \code{k} standard deviations from the mean). The function provides a summary of influential subjects,
separates the data into influential and non-influential subjects, calculates influence scores, and visualizes the results using \code{ggplot2}.
}
\details{
The function follows these steps:
\itemize{
  \item Calculates the mean and standard deviation of the response variable across all subjects.
  \item Determines the threshold for influence based on \code{k} standard deviations from the mean.
  \item Identifies subjects whose mean response falls outside this threshold.
  \item Calculates the Influence Score (IS) for each subject as the absolute deviation of their mean from the overall mean.
  \item Calculates the Proportional Influence Score (PIS) for each subject as IS divided by the overall standard deviation.
  \item Separates data into influential and non-influential subjects.
  \item Visualizes the distribution of responses and highlights influential subjects.
}

This method is useful for detecting outliers and understanding the impact of extreme values in longitudinal studies.
}
\examples{
data(infsdata)
infsdata <- infsdata[1:5,]
result <- slm(infsdata, "subject_id", "time", "response", 2)
print(result$influential_subjects)
head(result$influential_data)
head(result$non_influential_data)
head(result$influence_scores)
print(result$mean_plot)
print(result$longitudinal_plot)

}
\seealso{
tvm, wlm, sld, rld
}
