% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal.R
\name{iscaminvnorm}
\alias{iscaminvnorm}
\title{Inverse Normal Calculation}
\usage{
iscaminvnorm(prob1, mean = 0, sd = 1, Sd = sd, direction, verbose = TRUE)
}
\arguments{
\item{prob1}{probability to find normal quantile of.}

\item{mean}{mean of normal distribution.}

\item{sd}{standard deviation of normal distribution.}

\item{Sd}{deprecated--available for backwards compatibility.}

\item{direction}{direction for probability calculation: "above", "below",
"outside", "between".}

\item{verbose}{Logical, defaults to \code{TRUE}. Set to \code{FALSE} to suppress messages}
}
\value{
a plot of the normal distribution with the quantile of the specified
probability highlighted.
}
\description{
Inverse Normal Calculation
}
\examples{
iscaminvnorm(0.05, direction = "below")
iscaminvnorm(0.90, mean = 100, sd = 15, direction = "above")
iscaminvnorm(0.10, direction = "outside")
iscaminvnorm(0.95, direction = "between")
}
