% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skew-normal.R
\name{fit_skew_normal_samp}
\alias{fit_skew_normal_samp}
\title{Fit a skew normal distribution to a sample}
\usage{
fit_skew_normal_samp(x)
}
\arguments{
\item{x}{A numeric vector of sample data.}
}
\value{
A list with fitted parameters:
\itemize{
\item \code{xi}: location parameter
\item \code{omega}: scale parameter
\item \code{alpha}: shape parameter
\item \code{logC}: log-normalization constant
\item \code{k}: temperature parameter
\item \code{rsq}: R-squared of the fit
}

Note that \code{logC} and \code{k} are not used when fitting from a sample.
}
\description{
Fit a skew normal distribution to a sample
}
\details{
Uses maximum likelihood estimation to fit a skew normal distribution
to the provided numeric vector \code{x}.
}
\examples{
x <- rnorm(100, mean = 5, sd = 1)
unlist(fit_skew_normal_samp(x))
}
