% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_classes.R, R/cgeneric.R
\docType{class}
\name{cgeneric-class}
\alias{cgeneric-class}
\alias{cgeneric}
\alias{cgeneric.character}
\alias{cgeneric.function}
\alias{cgeneric.cgeneric}
\alias{cgeneric.inla.cgeneric}
\alias{cgenericBuilder}
\alias{mapper1}
\alias{cgeneric_shlib}
\alias{print.cgeneric}
\alias{summary.cgeneric}
\alias{plot.cgeneric}
\title{Organize data for the latent GMRF C interface for \code{INLA}.}
\usage{
cgeneric(model, ...)

\method{cgeneric}{character}(model, ...)

\method{cgeneric}{`function`}(model, ...)

\method{cgeneric}{cgeneric}(model, ...)

\method{cgeneric}{inla.cgeneric}(model, ...)

cgenericBuilder(...)

mapper1(model)

cgeneric_shlib(debug, package, useINLAprecomp)

\method{print}{cgeneric}(x, ...)

\method{summary}{cgeneric}(object, ...)

\method{plot}{cgeneric}(x, y, ...)
}
\arguments{
\item{model}{object class for what a \code{cgeneric} method exists.
E.g., if it is a character, a specific function will be called.
E.g. cgeneric("iid", ...") calls cgeneric_iid(...).}

\item{...}{not used}

\item{debug}{integer, used as verbose in debug.}

\item{package}{character giving the name of the package
that contains the \code{cgeneric} model.}

\item{useINLAprecomp}{logical, indicating if it is to use
the shared object previously copied and compiled by INLA.}

\item{x}{a cgeneric object}

\item{object}{a cgeneric object}

\item{y}{not used}
}
\value{
a method to build a \code{cgeneric} should return
a named list of \code{cgeneric} class that contains a
named list \code{f} that contains (at least):
\itemize{
\item \code{model} a character always equal to \code{cgeneric},
\item \code{n} an integer greater than 0, and
\item \code{cgeneric} as a named list that contains the
data needed to define the model. Each element on
...$f$cgeneric is also a named list containing
\code{ints}, \code{doubles}, \code{characters}, \code{matrices}
and \code{smatrices}.
\item (possible) \code{extraconstr} as a named list with: \code{A} as a
\code{n} times \code{k} matrix and \code{e} as a length \code{k} vector.
}

The \code{cgeneric_shlib} function returns a \code{character}
with the path to the shared lib.
}
\description{
A GMRF is defined from model parameters \eqn{\theta} that
would parametrize a (sparse) precision matrix.

The elements of a GMR are:
\itemize{
\item \code{graph} to define the non-zero precision matrix pattern.
only the upper triangle including the diagonal is needed.
\item \code{Q} vector where the
\itemize{
\item first element (N) is the size of the matrix,
\item second element (M) is the number of non-zero
elements in the upper part (including) diagonal
\item the remaining (M) elements are the actual
precision (upper triangle plus diagonal) elements
whose order shall follow the graph definition.
}
\item \code{mu} the mean vector,
\item \code{initial} vector with
\itemize{
\item first element as the number of the parameters in the model
\item remaining elements should be the initials for the model parameters.
}
\item \code{log.norm.const} log of the normalizing constant.
\item \code{log.prior} log of the prior for the model parameters.
}
}
\section{Functions}{
\itemize{
\item \code{cgeneric(cgeneric)}: Returns the model object unchanged.

\item \code{cgeneric(inla.cgeneric)}: Converts a regular \code{inla.cgeneric} object to \code{cgeneric}.

\item \code{mapper1()}: A default mapper for a cgeneric/rgeneric model

\item \code{print(cgeneric)}: Print the cgeneric object

\item \code{summary(cgeneric)}: A summary for a cgeneric object

\item \code{plot(cgeneric)}: A plot for a cgeneric object

}}
\note{
The \code{graph} and \code{Q} non-zero pattern should match,
its elements should be ordered by row,
and only its upper part stored.
}
\examples{
library(INLAtools)

R <- Sparse(crossprod(diff(diag(10))))
R

m <- cgeneric("generic0", R = R,
	      scale = FALSE,
	      param = c(1, 0.01))
m

all.equal(R, Sparse(prec(m, theta = 0)))

graph(m)
prior(m, theta = 0)
prior(m, theta = matrix(-1:1, 1)) ## see ?prior.cgeneric

}
\seealso{
\code{\link[=INLAtools-methods]{INLAtools-methods()}}
}
