% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APM.R
\name{APM}
\alias{APM}
\title{Aggregated Projection Method}
\usage{
APM(
  y,
  rmax = 8,
  r0 = NULL,
  r = NULL,
  localfactor = FALSE,
  weight = TRUE,
  method = "ic",
  type = "IC3"
)
}
\arguments{
\item{y}{A list of the observation data, each element is a data matrix of each group with dimension \eqn{T \times N_m}.}

\item{rmax}{The maximum factor numbers of all groups. Default is 8.}

\item{r0}{The number of global factors. Default is \code{NULL}, the algorithm will automatically estimate the number of global factors.
If you have prior information about the true number of global factors, you can set it manually.}

\item{r}{The number of local factors in each group. Default is \code{NULL}, the algorithm will automatically estimate the number of local factors.
If you have prior information, set it manually as an integer vector of length \eqn{M} (the number of groups).}

\item{localfactor}{Logical. If \code{FALSE} (default), local factors are not estimated. If \code{TRUE}, local factors will be estimated.}

\item{weight}{The weight of each projection matrix.
If \code{TRUE} (default), weights are \eqn{w_m = N_m/N}.
If \code{FALSE}, the mean of all projection matrices is calculated (equal weights).
Can also be a numeric vector of length \eqn{M} specifying custom weights.}

\item{method}{The method used in the algorithm. Default is \code{"ic"}, can also be \code{"gap"}.}

\item{type}{The method used in estimating the factor numbers in each group initially. Default is \code{"IC3"}.}
}
\value{
An object of class \code{"GFA"} containing:
\item{r0hat}{The estimated number of global factors.}
\item{rhat}{The estimated number of local factors (if \code{localfactor = TRUE}).}
\item{rho}{The first \code{rmax} eigenvalues of the weighted projection matrix.}
\item{Ghat}{The estimated global factors.}
\item{loading_G}{A list consisting of the estimated global factor loadings.}
\item{Fhat}{The estimated local factors (if \code{localfactor = TRUE}).}
\item{loading_F}{A list consisting of the estimated local factor loadings (if \code{localfactor = TRUE}).}
\item{residual}{A list consisting of the residuals (if \code{localfactor = TRUE}).}
\item{threshold}{The threshold used in determining the number of global factors (only for \code{method = "ic"}).}
}
\description{
Aggregated Projection Method for Group Factor Model.
}
\examples{
\dontrun{
dat <- GrFA::gendata()
APM(dat$y, rmax = 8, localfactor = TRUE, method = "ic")
APM(dat$y, rmax = 8, localfactor = TRUE, method = "gap")
}
}
\references{
Aggregated Projection Method: A New Approach for Group Factor Model. Jiaqi Hu, Ting Li, Xueqin Wang (2025). Journal of the American Statistical Association, doi:10.1080/01621459.2025.2491154
}
