% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POLMM.R
\name{fitNullModel.POLMM}
\alias{fitNullModel.POLMM}
\title{Fit POLMM null model for ordinal outcomes}
\usage{
fitNullModel.POLMM(
  response,
  designMat,
  subjData,
  control,
  optionGRM,
  GenoFile,
  GenoFileIndex,
  SparseGRMFile
)
}
\arguments{
\item{response}{Ordered factor response (lowest level coded as 0 internally).}

\item{designMat}{Numeric covariate matrix or data.frame (n x p).}

\item{subjData}{Character vector of subject IDs aligned with rows of
\code{designMat} and \code{response}.}

\item{control}{List of POLMM options (e.g., \code{tau},
\code{maxMissingVarRatio}, \code{minMafVarRatio}).}

\item{optionGRM}{Character, either \code{"DenseGRM"} or \code{"SparseGRM"}.}

\item{GenoFile}{Character, path to genotype file (PLINK or BGEN format).}

\item{GenoFileIndex}{Character or NULL, path to genotype index files.
If NULL, uses same prefix as \code{GenoFile}.}

\item{SparseGRMFile}{Character or NULL, path to sparse GRM file.
If provided, sparse GRM is used; otherwise dense GRM is constructed.}
}
\value{
An object of class \code{"POLMM_NULL_Model"} representing the
initialized null model; state is stored in C++ and not intended for direct
element-wise access from R.
}
\description{
Initializes the POLMM null model from an ordered categorical response and
covariate matrix, preparing C++ state for subsequent marker/region tests.
}
\keyword{internal}
