% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRAB_Simu.R
\name{GRAB.makePlink}
\alias{GRAB.makePlink}
\title{Convert genotype matrix to PLINK format files}
\usage{
GRAB.makePlink(
  GenoMat,
  OutputPrefix,
  A1 = "G",
  A2 = "A",
  CHR = NULL,
  BP = NULL,
  Pheno = NULL,
  Sex = NULL
)
}
\arguments{
\item{GenoMat}{Numeric genotype matrix (n×m) with values 0, 1, 2, or -9.
Rows = subjects, columns = markers. Row and column names are required.}

\item{OutputPrefix}{Output file prefix including path (without extension).}

\item{A1}{Allele 1 character, usually minor/ALT allele (default: "G").}

\item{A2}{Allele 2 character, usually major/REF allele (default: "A").}

\item{CHR}{Chromosome numbers for markers (default: all chromosome 1).}

\item{BP}{Base positions for markers (default: 1:m).}

\item{Pheno}{Phenotype values for subjects (default: all missing as -9).}

\item{Sex}{Sex codes for subjects (default: all coded as 1).}
}
\value{
Character message confirming file creation location.
}
\description{
Converts a numeric genotype matrix to PLINK text files (PED and MAP format)
for use with PLINK software and other genetic analysis tools.
}
\details{
\strong{Genotype Encoding:}
\itemize{
\item 0, 1, 2 → copies of minor allele
\item -9 → missing genotype (coded as "00" in PED)
\item A1="G", A2="A": 0→"GG", 1→"AG", 2→"AA", -9→"00"
}

\strong{Output Files:}
\itemize{
\item \code{.ped}: Pedigree file with genotype data
\item \code{.map}: Marker map file with positions
}

\strong{Downstream Processing:}

\if{html}{\out{<div class="sourceCode bash">}}\preformatted{# Convert to binary format
plink --file prefix --make-bed --out prefix

# Convert to raw format
plink --bfile prefix --recode A --out prefix_raw

# Convert to BGEN format
plink2 --bfile prefix --export bgen-1.2 bits=8 ref-first --out prefix_bgen

# Create BGEN index
bgenix -g prefix_bgen.bgen --index
}\if{html}{\out{</div>}}
}
\examples{
### Step 1: simulate a numeric genotype matrix
n <- 1000
m <- 20
MAF <- 0.3
set.seed(123)
GenoMat <- matrix(rbinom(n * m, 2, MAF), n, m)
rownames(GenoMat) <- paste0("Subj-", 1:n)
colnames(GenoMat) <- paste0("SNP-", 1:m)
OutputDir <- tempdir()
outputPrefix <- file.path(OutputDir, "simuPLINK")

### Step 2(a): make PLINK files without missing genotype
GRAB.makePlink(GenoMat, outputPrefix)

### Step 2(b): make PLINK files with genotype missing rate of 0.1
indexMissing <- sample(n * m, 0.1 * n * m)
GenoMat[indexMissing] <- -9
GRAB.makePlink(GenoMat, outputPrefix)

## The following are in shell environment
# plink --file simuPLINK --make-bed --out simuPLINK
# plink --bfile simuPLINK --recode A --out simuRAW
# plink2 --bfile simuPLINK --export bgen-1.2 bits=8 ref-first --out simuBGEN
# UK Biobank use 'ref-first'
# bgenix -g simuBGEN.bgen --index


}
