% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda.cv.R
\name{lambda.cv}
\alias{lambda.cv}
\title{Choose the Tuning Parameter of the Ridge Inverse}
\usage{
lambda.cv(x, lambda, fold)
}
\arguments{
\item{x}{An n by p data matrix.}

\item{lambda}{A numeric vector of candidate tuning parameters.}

\item{fold}{fold-cross validation is performed.}
}
\value{
A list containing
 \item{lambda }{The selected tuning parameter, which minimizes the 
   total prediction errors. }
 \item{spe }{The total prediction error for all the candidate 
   lambda values.}
}
\description{
Choose the tuning parameter of the ridge inverse by minimizing cross 
  validation estimates of the total prediction errors of the p separate 
  ridge regressions.
}
\examples{
 p <- 100 # number of variables
 n <- 50 # sample size
 
 ###############################
 # Simulate data
 ###############################
 simulation <- simulateData(G = p, etaA = 0.02, n = n, r = 1)
 data <- simulation$data[[1L]]
 stddata <- scale(x = data, center = TRUE, scale = TRUE)
 
 ###############################
 # estimate ridge parameter
 ###############################
 lambda.array <- seq(from = 0.1, to = 20, by = 0.1) * (n - 1.0)
 fit <- lambda.cv(x = stddata, lambda = lambda.array, fold = 10L)
 lambda <- fit$lambda[which.min(fit$spe)] / (n - 1.0)
 
 ###############################
 # calculate partial correlation 
 # using ridge inverse
 ###############################
 partial <- solve(lambda*diag(p) + cor(data))
 partial <- -scaledMat(x = partial)

}
\references{
Ha, M. J. and Sun, W. 
 (2014).
 Partial correlation matrix estimation using ridge penalty followed 
 by thresholding and re-estimation.
 Biometrics, 70, 762--770.
}
\author{
Min Jin Ha
}
