% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov_functions.R
\name{vcov_POET}
\alias{vcov_POET}
\title{POET estimation of the covariance for the error terms}
\usage{
vcov_POET(object, C = 1.5)
}
\arguments{
\item{object}{An S3 object of class 'multi_result' created by [multilevel()].}

\item{C}{A positive constant in the adaptive threshold.}
}
\value{
An \eqn{N \times N} covariance matrix.
}
\description{
This function generates POET covariance estimates for the error terms.
}
\examples{

panel <- UKhouse # load the data
est_multi <- multilevel(panel, ic = "BIC3", standarise = TRUE, r_max = 5,
                           depvar_header = "dlPrice", i_header = "Region",
                           j_header = "LPA_Type", t_header = "Date")
Sigma_e_POET <- vcov_POET(est_multi)
}
