% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar.evaluate.core.R
\name{bar.evaluate.core}
\alias{bar.evaluate.core}
\title{Bar Plots}
\usage{
bar.evaluate.core(
  data,
  names,
  qualitative,
  selected,
  na.omit = TRUE,
  show.count = FALSE
)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string.}

\item{qualitative}{Name of columns with the qualitative traits as a character
vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}

\item{na.omit}{logical. If \code{TRUE}, missing values (\code{NA}) are
ignored and not included in the plot as a distinct factor level. Default is
\code{TRUE}.}

\item{show.count}{logical. If \code{TRUE}, the accession count excluding
missing values will also be displayed. Default is \code{FALSE}.}
}
\value{
A list with the \code{ggplot} objects of relative frequency bar plots
  of CS and EC for each trait specified as \code{qualitative}.
}
\description{
Plot Bar plots to graphically compare the frequency distributions of
qualitative traits between entire collection (EC) and core set (CS).
}
\examples{

data("cassava_CC")
data("cassava_EC")

ec <- cbind(genotypes = rownames(cassava_EC), cassava_EC)
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL

core <- rownames(cassava_CC)

quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")

ec[, qual] <- lapply(ec[, qual],
                     function(x) factor(as.factor(x)))

\donttest{
bar.evaluate.core(data = ec, names = "genotypes",
                  qualitative = qual, selected = core)
bar.evaluate.core(data = ec, names = "genotypes",
                  qualitative = qual, selected = core,
                  show.count = TRUE)
}

}
\seealso{
\code{\link[graphics]{barplot}}, \code{\link[ggplot2]{geom_bar}}
}
