% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_infection_summary}
\alias{create_infection_summary}
\title{Create summary output from infection estimation objects}
\usage{
create_infection_summary(
  object,
  type = c("snapshot", "parameters"),
  target_date = NULL,
  params = NULL,
  CrIs = c(0.2, 0.5, 0.9),
  ...
)
}
\arguments{
\item{object}{An infection estimation object (either from
\code{\link[=estimate_infections]{estimate_infections()}} or \code{\link[=forecast_infections]{forecast_infections()}}).}

\item{type}{A character vector of data types to return. Defaults to
"snapshot" but also supports "parameters". "snapshot" returns
a summary at a given date (by default the latest date informed by data).
"parameters" returns summarised parameter estimates that can be further
filtered using \code{params} to show just the parameters of interest and date.}

\item{target_date}{Date, defaults to maximum found in the data if not
specified.}

\item{params}{A character vector of parameters to filter for.}

\item{CrIs}{Numeric vector of credible intervals to calculate. Defaults
to c(0.2, 0.5, 0.9).}

\item{...}{Additional arguments passed to \code{\link[=report_summary]{report_summary()}}.}
}
\value{
A \verb{<data.frame>} of summary output, either a snapshot summary
(via \code{\link[=report_summary]{report_summary()}}) or parameter summaries (via
\code{\link[=calc_summary_measures]{calc_summary_measures()}}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function creates summary output from infection estimation objects
(either \code{estimate_infections} or \code{forecast_infections}). It is used
internally by \code{\link[=summary.estimate_infections]{summary.estimate_infections()}} and
\code{\link[=summary.forecast_infections]{summary.forecast_infections()}} to provide a consistent summary interface.
}
\seealso{
\code{\link[=summary.estimate_infections]{summary.estimate_infections()}} \code{\link[=summary.forecast_infections]{summary.forecast_infections()}}
\code{\link[=report_summary]{report_summary()}} \code{\link[=calc_summary_measures]{calc_summary_measures()}}
}
\keyword{internal}
