% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{apply_zero_threshold}
\alias{apply_zero_threshold}
\title{Convert zero case counts to \code{NA} (missing) if the 7-day average is above a
threshold.}
\usage{
apply_zero_threshold(data, threshold = Inf, obs_column = "confirm")
}
\arguments{
\item{data}{A \verb{<data.frame>} of disease reports (confirm) by date (date).
\code{confirm} must be numeric and \code{date} must be in date format. Optionally,
\code{data} can also have a logical \code{accumulate} column which indicates whether
data should be added to the next data point. This is useful when modelling
e.g. weekly incidence data. See also the \code{\link[=fill_missing]{fill_missing()}} function which
helps add the \code{accumulate} column with the desired properties when dealing
with non-daily data. If any accumulation is done this happens after
truncation as specified by the \code{truncation} argument. If all entries
of \code{confirm} are missing (\code{NA}) the returned estimates will represent the
prior distributions.}

\item{threshold}{Numeric, defaults to \code{Inf}. Indicates if detected zero
cases are meaningful by using a threshold number of cases based on the
7-day average. If the average is above this threshold at the time of a
zero observation count then the zero is replaced with a missing (\code{NA})
count and thus ignored in the likelihood.}

\item{obs_column}{Character (default: "confirm"). If given, only the column
specified here will be used for checking missingness. This is useful if
using a data set that has multiple columns of hwich one of them
corresponds to observations that are to be processed here.}
}
\value{
A data.table with the zero threshold applied.
}
\description{
This function aims to detect spurious zeroes by comparing the 7-day average
of the case counts to a threshold. If the 7-day average is above the
threshold, the zero case count is replaced with \code{NA}.
}
