% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{analyze_fixed_points}
\alias{analyze_fixed_points}
\title{Analyze Fixed Points}
\usage{
analyze_fixed_points(
  equation,
  variable,
  range = c(-10, 10),
  n_grid = 100,
  exogenous_values = list()
)
}
\arguments{
\item{equation}{Fitted equation object.}

\item{variable}{Name of the main variable.}

\item{range}{Numeric vector of length 2 specifying search range.}

\item{n_grid}{Number of grid points for initial search.}

\item{exogenous_values}{Named list of fixed values for exogenous variables.}
}
\value{
Data frame of fixed points with stability classification.
}
\description{
Finds and characterizes fixed points of the discovered equation.
}
\examples{
\donttest{
# Toy example: dZ = 2*Z - Z^2 (Logistic growth)
data <- data.frame(Z = seq(0.1, 3, length.out=50))
data$dZ <- 2*data$Z - data$Z^2
model <- stats::lm(dZ ~ I(Z) + I(Z^2) + 0, data = data)

# Analyze (note: linear models on dZ aren't direct ODEs, but this demonstrates structure)
# For correct usage, 'equation' should be from fit_specified_equation
fp <- analyze_fixed_points(model, variable = "Z", range = c(0, 3))
}
}
