% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tilac_fraction_design}
\alias{tilac_fraction_design}
\title{TILAC \code{fraction_design} table for \code{EstimateFractions}}
\format{
\subsection{\code{tilac_fraction_design}}{

A tibble with 4 rows and 3 columns:
\describe{
\item{TC}{Boolean denoting if population represented by that row has high T-to-C mutational content}
\item{GA}{Boolean denoting if population represented by that row has high G-to-A mutational content}
\item{present}{Boolean denoting if population represented by that row is expected to be present in this dataset}
}
}
}
\usage{
tilac_fraction_design
}
\description{
An example \code{fraction_design} table for a TILAC experiment. TILAC was originally
described in \href{https://pubmed.ncbi.nlm.nih.gov/36018791/}{Courvan et al., 2022}. In this
method, two populations of RNA, one from s^4U fed cells and one from s^6G fed cells, are pooled
and prepped for sequencing together. This allows for internally controlled comparisons of RNA
abundance without spike-ins. s^4U is recoded to a cytosine analog by TimeLapse chemistry
(or similar chemistry) and s^6G is recoded to an adenine analog. Thus, \code{fraction_design} includes
columns called \code{TC} and \code{GA}. A unique aspect of the TILAC \code{fraction_design} table is that
one of the possible populations, \code{TC} and \code{GA} both \code{TRUE}, is denoted as not present (\code{present} = \code{FALSE}).
This is because there is no RNA was exposed to both s^4U and s^6G, thus a population of reads
with both high T-to-C and G-to-A mutational content should not exist.
}
\keyword{datasets}
