% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_evaluate_report_summary.R
\name{read_evaluate_report_summary}
\alias{read_evaluate_report_summary}
\title{Summarize the evaluate quality report}
\usage{
read_evaluate_report_summary(
  transaction,
  with_exceptions = TRUE,
  env = "production"
)
}
\arguments{
\item{transaction}{(character) Transaction identifier}

\item{with_exceptions}{(logical) Convert quality report warnings and errors
to R warnings and errors}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(message/warning/error) A message listing the total number of checks
resulting in valid, info, warn, and error status. Exceptions are raised if
warnings and errors are found and \code{with_exceptions} is TRUE.
}
\description{
Summarize the evaluate quality report
}
\details{
Get \code{transaction} from \code{evaluate_data_package()}
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

login()

# Evaluate data package
transaction <- evaluate_data_package(
  eml = paste0(tempdir(), "/edi.595.1.xml"),
  env = "staging"
)
transaction
#> [1] "evaluate_163966785813042760"


# Summarize report
read_evaluate_report_summary(transaction, env = "staging")
#> ===================================================
#>   EVALUATION REPORT
#> ===================================================
#>
#> PackageId: edi.595.1
#> Report Date/Time: 2021-12-16T22:49:25
#> Total Quality Checks: 29
#> Valid: 21
#> Info: 8
#> Warn: 0
#> Error: 0


logout()
}

}
\seealso{
Other Accessing: 
\code{\link{read_data_entity}()},
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_package}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_metadata}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()}
}
\concept{Accessing}
