% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Input.R
\name{LstepCE1}
\alias{LstepCE1}
\alias{LstepCE2}
\title{Step-wise Constant Effort}
\usage{
LstepCE1(
  x,
  Data,
  reps = 100,
  plot = FALSE,
  yrsmth = 5,
  stepsz = 0.05,
  llim = c(0.96, 0.98, 1.05)
)

LstepCE2(
  x,
  Data,
  reps = 100,
  plot = FALSE,
  yrsmth = 5,
  stepsz = 0.1,
  llim = c(0.96, 0.98, 1.05)
)
}
\arguments{
\item{x}{A position in the data object}

\item{Data}{A data object}

\item{reps}{The number of stochastic samples of the MP recommendation(s)}

\item{plot}{Logical. Show the plot?}

\item{yrsmth}{Years over which to calculate trend in mean length.}

\item{stepsz}{Parameter controlling the size of update increment in effort.}

\item{llim}{A vector of length reference points that determine the
conditions for increasing, maintaining or reducing the effort.}
}
\value{
An object of class \code{\link[MSEtool]{Rec-class}} with the TAE slot(s) populated
}
\description{
A management procedure that incrementally adjusts the total allowable
effort (TAE) according to the mean length of recent catches.
}
\details{
The TAE is calculated as:
\deqn{\textrm{TAE} =
             \left\{\begin{array}{ll}
             \textrm{TAE}^* - 2 S\textrm{TAE}^* & \textrm{if } r < 0.96  \\
             \textrm{TAE}^* - S \textrm{TAE}^* & \textrm{if } r < 0.98 \\
             \textrm{TAE}^* & \textrm{if } > 1.058 \\
             \end{array}\right.
           }
where \eqn{\textrm{TAE}^*} is effort in the previous year, \eqn{S} is
step-size determined by \code{stepsz},
and \eqn{r} is the ratio of \eqn{L_\textrm{recent}} and \eqn{L_\textrm{ave}}
which are mean length over the most recent \code{yrsmth}  years and 2 x \code{yrsmth} historical
years respectively.

The conditions are specified in the \code{llim} argument to the function.
}
\section{Functions}{
\itemize{
\item \code{LstepCE1()}: The least biologically precautionary effort-based MP.

\item \code{LstepCE2()}: Step size is increased to 0.1

}}
\section{Required Data}{

See \code{\link[MSEtool]{Data-class}} for information on the \code{Data} object \cr


\code{LstepCE1}: LHYear, ML, MPeff, Year
}

\section{Rendered Equations}{

See \href{https://dlmtool.openmse.com/reference/LstepCE1.html}{Online Documentation} for correctly rendered equations
}

\examples{
LstepCE1(1, Data=MSEtool::SimulatedData, plot=TRUE)
LstepCE2(1, Data=MSEtool::SimulatedData, plot=TRUE)
}
\references{
Carruthers et al. 2015. Performance evaluation of simple
management procedures. ICES J. Mar Sci. 73, 464-482.

Geromont, H.F., Butterworth, D.S. 2014. Generic management procedures for
data-poor fisheries; forecasting with few data. ICES J. Mar. Sci.
doi:10.1093/icesjms/fst232
}
\seealso{
LstepCC1
}
\author{
T. Carruthers
}
