% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor.tests.R
\name{factor.tests}
\alias{factor.tests}
\title{Factor Model Testing with Wald, GRS, PY tests and FDR control}
\usage{
factor.tests(ret, fac, q.fdr = 0.05)
}
\arguments{
\item{ret}{A T × N matrix representing the excess returns of N assets at T time points.}

\item{fac}{A T × K matrix representing the returns of K factors at T time points.}

\item{q.fdr}{The significance level for FDR (False Discovery Rate) testing, defaulting to 5\%.}
}
\value{
A list containing the following components:
\item{alpha}{N-vector of estimated alphas for each asset}
\item{tstat}{N-vector of t-statistics for testing individual alphas}
\item{pval}{N-vector of p-values for individual alpha tests}
\item{Wald}{Wald test statistic for joint alpha significance}
\item{p_Wald}{p-value for Wald test}
\item{GRS}{GRS test statistic (finite-sample F-test)}
\item{p_GRS}{p-value for GRS test}
\item{PY}{Pesaran and Yamagata test statistic}
\item{p_PY}{p-value for PY test}
\item{reject_fdr}{Logical vector indicating which assets have significant alphas after FDR correction}
\item{fdr_p}{Adjusted p-values using Benjamini-Hochberg procedure}
\item{power_proxy}{Number of significant assets after FDR correction}
}
\description{
Performs comprehensive factor model testing including joint tests (Wald, GRS, PY), 
individual asset t-tests, and False Discovery Rate control.
}
\examples{
set.seed(42)
T <- 120
N <- 25
K <- 3
fac <- matrix(rnorm(T * K), T, K)
beta <- matrix(rnorm(N * K), N, K)
alpha <- rep(0, N)
alpha[1:3] <- 0.4 / 100  # 3 non-zero alphas
eps <- matrix(rnorm(T * N, sd = 0.02), T, N)
ret <- alpha + fac \%*\% t(beta) + eps
results <- factor.tests(ret, fac, q.fdr = 0.05)

# View results
cat("Wald test p-value:", results$p_Wald, "\n")
cat("GRS test p-value:", results$p_GRS, "\n")
cat("PY test p-value:", results$p_PY, "\n")
cat("Significant assets after FDR:", results$power_proxy, "\n")

}
