% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icu.R
\docType{data}
\name{icu}
\alias{icu}
\title{DIVINE's table on icu data}
\format{
A data frame with 5813 rows and 14 columns
\describe{
\item{record_id:}{Identifier of each record. This information does not match the real data.}
\item{covid_wave:}{A factor with levels \verb{Wave 1}, \verb{Wave 2}, \verb{Wave 3}, and \verb{Wave 5}. COVID-19 wave.}
\item{center:}{A factor with levels \verb{Hospital A}, \verb{Hospital B}, \verb{Hospital C}, \verb{Hospital D}, and  \verb{Hospital E}. Center of admission}
\item{icu:}{A factor with levels \code{No} and \code{Yes}. Was the patient admitted to the ICU?}
\item{icu_enter_days:}{Days from hospital admission to ICU admission.}
\item{icu_exit_days:}{Days from hospital admission to ICU discharge.}
\item{vent_mec:}{A factor with levels \code{No} and \code{Yes}. Did the patient received invasive mechanical ventilation?}
\item{vent_mec_start_days:}{Days from hospital admission to start of invasive mechanical ventilation.}
\item{vent_mec_end_days:}{Days from hospital admission to end of invasive mechanical ventilation.}
\item{vent_mec_no_inv:}{A factor with levels \code{No} and \code{Yes}. Did the patient received non-invasive mechanical ventilation?}
\item{vent_mec_no_inv_start_days:}{Days from hospital admission to start of non-invasive mechanical ventilation.}
\item{vent_mec_no_inv_end_days:}{Days from hospital admission to end of non-invasive mechanical ventilation.}
\item{sev_pneum}{A factor with levels \code{No} and \code{Yes}. Did the patient required a sustained supply of oxygen therapy greater than FiO2 of 35\% to maintain oxygen saturation above 95\%?}
\item{sev_pneum_days}{Days from hospital admission to development of severe pneumonia.}
}
}
\usage{
data(icu)
}
\description{
Information on ICU data of patients included in the DIVINE cohort. Data was collected during hospitalization.
}
\references{
Pallarès, N., Tebé, C., Abelenda-Alonso, G., Rombauts, A., Oriol, I., Simonetti, A. F., Rodríguez-Molinero, A., Izquierdo, E., Díaz-Brito, V., Molist, G., Gómez Melis, G., Carratalà, J., Videla, S., & MetroSud and Divine study groups (2023). Characteristics and Outcomes by Ceiling of Care of Subjects Hospitalized with COVID-19 During Four Waves of the Pandemic in a Metropolitan Area: A Multicenter Cohort Study. Infectious diseases and therapy, 12(1), 273–289. https://doi.org/10.1007/s40121-022-00705-w
}
\keyword{datasets}
