#' Data upload
#'
#' Safely uploads data to be processed in DIETCOST software.
#' @param filepath The filepath in which the dataset, in .xlsx format, is saved.
#' @param sheet The sheet of the .xlsx to be read.
#' @return The dataframe generated by the file which was read.
#' @export
upload_data <- function(filepath, sheet){
  df<- tryCatch(
    expr = {read_excel(filepath, sheet)},
    error = function(e){
      message('Upload failed!')
      stop(e)}
  )
  return(df)
}