predict_DDPstar.denfun <-
function(object, newdata, sequence, parallel = c("no", "multicore", "snow"), ncpus = 1, cl = NULL) {
	doMCMC <- function(k, object, Xp, sequence) {
		denfun <- matrix(0, nrow = length(sequence), ncol = nrow(Xp))
		ncomp <- ncol(object$fit$probs)
		if(ncomp == 1) {
			Beta <- matrix(object$fit$beta[k,,], nrow = 1)
		} else {
			Beta <- object$fit$beta[k,,]
		}
		
		mu <- Xp%*%t(Beta)
		sigma <- object$fit$sd[k,]
		w <- object$fit$probs[k,]
		for(i in 1:nrow(Xp)) {
			for(j in 1:length(sequence)) {
				denfun[j,i] <- sum(w*dnorm(sequence[j], mean = c(mu[i,]), sd = sigma))
			}
		}
		res <- list()
		res$denfun <- denfun
		res$foo <- 1
		res
	}

	Xp <- predict.design.matrix.DDPstar(object = object, newdata = newdata)$X
	
	parallel <- match.arg(parallel)

	nsim <- nrow(object$fit$sd)
	if(nsim > 0) {
		do_mc <- do_snow <- FALSE
	    if (parallel != "no" && ncpus > 1L) {
	        if (parallel == "multicore") {
	            do_mc <- .Platform$OS.type != "windows"
	        } else if (parallel == "snow") {
	            do_snow <- TRUE
	        }
	        if (!do_mc && !do_snow) {
	            ncpus <- 1L
	        }       
	        loadNamespace("parallel") # get this out of the way before recording seed
	    }

	    resMCMC <- if (ncpus > 1L && (do_mc || do_snow)) {
                if (do_mc) {
                    parallel::mclapply(seq_len(nsim), doMCMC, object = object, Xp = Xp, sequence = sequence, mc.cores = ncpus)
                } else if (do_snow) {                
                    if (is.null(cl)) {
                        cl <- parallel::makePSOCKcluster(rep("localhost", ncpus))
                        if(RNGkind()[1L] == "L'Ecuyer-CMRG") {
                            parallel::clusterSetRNGStream(cl)
                        }
                        res <- parallel::parLapply(cl, seq_len(nsim), doMCMC, object = object, Xp = Xp, sequence = sequence)
                        parallel::stopCluster(cl)
                        res
                    } else {
                        if(!inherits(cl, "cluster")) {
                            stop("Class of object 'cl' is not correct")
                        } else {
                            parallel::parLapply(cl, seq_len(nsim), doMCMC, object = object, Xp = Xp, sequence = sequence)
                        }                        
                    }
                }
            } else {
                lapply(seq_len(nsim), doMCMC, object = object, Xp = Xp, sequence = sequence)
            }

        resMCMC <- simplify2array(resMCMC)
        denfun <- simplify2array(resMCMC["denfun",])

	} else {
		stop("nsave should be larger than zero.")
	}

	res <- list()
	res$Xp <- Xp
	res$sequence <- sequence
	res$denfun <- denfun
	class(res) <- "DDPstar.denfun"
	res
}
