% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{cds_estimate_costs}
\alias{cds_estimate_costs}
\title{Check the cost of a request against your quota}
\usage{
cds_estimate_costs(dataset, ..., token = cds_get_token())
}
\arguments{
\item{dataset}{A dataset name to be inspected}

\item{...}{Parameters passed on to \code{cds_build_request()}}

\item{token}{An API key to be used for authentication. Will use
\code{cds_get_token()} by default.}
}
\value{
Returns a named list indicating the available quota and
the estimated cost for a request specified with \code{...}-arguments.
}
\description{
Each account has a limit to the amount of data that can be downloaded.
Use this function to check if a request exceeds your quota.
}
\examples{
if (interactive() && cds_token_works()) {
  cds_estimate_costs(
    dataset        = "reanalysis-era5-pressure-levels",
    variable       = "geopotential",
    product_type   = "reanalysis",
    area           = c(n = 55, w = -1, s = 50, e = 10),
    year           = "2024",
    month          = "03",
    day            = "01",
    pressure_level = "1000",
    data_format    = "netcdf"
  )
  
  cds_estimate_costs(dataset = "reanalysis-era5-pressure-levels")
}
}
