% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableAchillesCodeUse.R
\name{tableAchillesCodeUse}
\alias{tableAchillesCodeUse}
\title{Format the result of summariseAchillesCodeUse into a table}
\usage{
tableAchillesCodeUse(
  result,
  type = "gt",
  header = c("cdm_name", "estimate_name"),
  groupColumn = character(),
  hide = character(),
  style = "default",
  .options = list()
)
}
\arguments{
\item{result}{A \verb{<summarised_result>} with results of the type
"achilles_code_use".}

\item{type}{Type of desired formatted table. To see supported formats
use visOmopResults::tableType().}

\item{header}{A vector specifying the elements to include in the header. The
order of elements matters, with the first being the topmost header.
The header vector can contain one of the following variables: "cdm_name",
"codelist_name", "domain_id", "standard_concept_name", "standard_concept_id",
"estimate_name", "standard_concept", "vocabulary_id".
Alternatively, it can include other names to use as overall header labels.}

\item{groupColumn}{Variables to use as group labels. Allowed columns are:
"cdm_name", "codelist_name", "domain_id", "standard_concept_name",
"standard_concept_id", "estimate_name", "standard_concept", "vocabulary_id".
These cannot be used in header.}

\item{hide}{Table columns to exclude, options are:  "cdm_name",
"codelist_name", "domain_id", "standard_concept_name", "standard_concept_id",
"estimate_name", "standard_concept", "vocabulary_id". These cannot be used in
header or groupColumn.}

\item{style}{A character string or custom R code to define the visual formatting
of the table. This argument can be provided in two ways: (1) Pre-defined Styles
(Character String): Use a name for a built-in style (e.g., "darwin"). See
visOmopResults::tableStyle() for available options. (2) Custome Code (Advanced):
Supply a block of custom R code. This code must be specific to the table type.
See visOmopResults::tableStyleCode() for structural examples.}

\item{.options}{Named list with additional formatting options.
visOmopResults::tableOptions() shows allowed arguments and
their default values.}
}
\value{
A table with a formatted version of the summariseCohortCodeUse
result.
}
\description{
Format the result of summariseAchillesCodeUse into a table
}
\examples{
\donttest{
library(CodelistGenerator)
library(omopgenerics)

cdm <- mockVocabRef("database")
oa <- getCandidateCodes(cdm = cdm, keywords = "osteoarthritis")
result_achilles <- summariseAchillesCodeUse(newCodelist(list(oa = oa$concept_id)),
                                            cdm = cdm)
tableAchillesCodeUse(result_achilles)
CDMConnector::cdmDisconnect(cdm)
}

}
