% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableDrugIngredients.R
\name{availableDrugIngredients}
\alias{availableDrugIngredients}
\title{Get the names of all available drug ingredients}
\usage{
availableDrugIngredients(cdm, standardConcept = "Standard")
}
\arguments{
\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{standardConcept}{Character vector with one or more of "Standard",
"Classification", and "Non-standard". These correspond to the flags used
for the standard_concept field in the concept table of the cdm.}
}
\value{
A vector containing the concept names for all ingredient level codes
found in the concept table of cdm.
}
\description{
Get the names of all available drug ingredients
}
\examples{
\donttest{
library(CodelistGenerator)
library(omock)

# Create CDM object
cdm <- mockCdmReference()

# Get all drug ingredients available in the CDM for standard concepts
availableDrugIngredients(cdm = cdm)
}
}
