\name{MultiChainLadderSummary-class}
\docType{class}
\alias{MultiChainLadderSummary-class}
\alias{$,MultiChainLadderSummary-method}
\alias{[[,MultiChainLadderSummary,numeric,missing-method}
\alias{[[,MultiChainLadderSummary,character,missing-method}
\alias{names,MultiChainLadderSummary-method}
\alias{show,MultiChainLadderSummary-method}

\title{Class "MultiChainLadderSummary"  }
\description{	 This class stores the summary statistics from a "MultiChainLadder" object. These summary statistics include both model summary and report summary. }
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("MultiChainLadderSummary", ...)}, or a call from \code{summary}.
}
\section{Slots}{
	 \describe{
    \item{\code{Triangles}:}{Object of class \code{"triangles"} }
    \item{\code{FullTriangles}:}{Object of class \code{"triangles"} }
    \item{\code{S.E.Full}:}{Object of class \code{"list"}  }
    \item{\code{S.E.Est.Full}:}{Object of class \code{"list"}  }
    \item{\code{S.E.Proc.Full}:}{Object of class \code{"list"}  }
    \item{\code{Ultimate}:}{Object of class \code{"matrix"}  }
    \item{\code{IBNR}:}{Object of class \code{"matrix"}  }
    \item{\code{S.E.Ult}:}{Object of class \code{"matrix"}  }
    \item{\code{S.E.Est.Ult}:}{Object of class \code{"matrix"}  }
    \item{\code{S.E.Proc.Ult}:}{Object of class \code{"matrix"}  }
    \item{\code{report.summary}:}{Object of class \code{"list"}  }
    \item{\code{coefficients}:}{Object of class \code{"list"}  }
    \item{\code{coefCov}:}{Object of class \code{"list"}  }
    \item{\code{residCov}:}{Object of class \code{"list"}  }
    \item{\code{rstandard}:}{Object of class \code{"matrix"}  }
    \item{\code{fitted.values}:}{Object of class \code{"matrix"}  }
    \item{\code{residCor}:}{Object of class \code{"matrix"}  }
    \item{\code{model.summary}:}{Object of class \code{"matrix"}  }
    \item{\code{portfolio}:}{Object of class \code{"NullChar"}  }
  }
}
\section{Methods}{
  \describe{
    \item{$}{\code{signature(x = "MultiChainLadderSummary")}: Method for primitive function \code{"$"}. It extracts a slot of \code{x} with a specified slot name, just as in list. }
    \item{[[}{\code{signature(x = "MultiChainLadderSummary", i = "numeric", j = "missing")}: Method for primitive function \code{"[["}. It extracts the i-th slot of a \code{"MultiChainLadder"} object, just as in list. \code{i} could be a vetor. }
    \item{[[}{\code{signature(x = "MultiChainLadderSummary", i = "character", j = "missing")}: Method for primitive function \code{"[["}. It extracts the slots of a \code{"MultiChainLadder"} object with names in \code{i}, just as in list. \code{i} could be a vetor. }
    \item{names}{\code{signature(x = "MultiChainLadderSummary")}:  Method for function \code{names}, which returns the slot names of a \code{"MultiChainLadder"} object. }
    \item{show}{\code{signature(object = "MultiChainLadderSummary")}: Method for \code{show}. }
	 }
}

\author{ Wayne Zhang \email{actuary_zhang@hotmail.com} }



\seealso{See also \code{\link{summary,MultiChainLadder-method}}, \code{\link{MultiChainLadder-class}}
}
\examples{
showClass("MultiChainLadderSummary")
}
\keyword{classes}
