% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_pyDarwinOptions.R
\name{write_pyDarwinOptions}
\alias{write_pyDarwinOptions}
\title{Write pyDarwin options to a JSON file.}
\usage{
write_pyDarwinOptions(
  pyDarwinOptions = create_pyDarwinOptions(),
  file = "options.json",
  pretty = TRUE,
  digits = NA,
  auto_unbox = TRUE
)
}
\arguments{
\item{pyDarwinOptions}{A list containing the pyDarwin options to be written
to the JSON file. Default is the result of calling \code{\link[=create_pyDarwinOptions]{create_pyDarwinOptions()}}
with default arguments.}

\item{file}{Character: The path to the JSON file where the options will be
written. Default is a file named "options.json" in the current working
directory.}

\item{pretty}{adds indentation whitespace to JSON output. Can be TRUE/FALSE or a number specifying the number of spaces to indent (default is 2). Use a negative number for tabs instead of spaces.}

\item{digits}{max number of decimal digits to print for numeric values. Use \code{\link[=I]{I()}} to specify significant digits. Use \code{NA} for max precision.}

\item{auto_unbox}{automatically \code{\link[jsonlite:unbox]{unbox()}} all atomic vectors of length 1. It is usually safer to avoid this and instead use the \code{\link[jsonlite:unbox]{unbox()}} function to unbox individual elements.
An exception is that objects of class \code{AsIs} (i.e. wrapped in \code{\link[=I]{I()}}) are not automatically unboxed. This is a way to mark single values as length-1 arrays.}
}
\value{
None (invisible \code{NULL}).
}
\description{
This function takes a list of pyDarwin options and writes them to a JSON file
in the specified format. The options can be generated using the
\code{create_pyDarwinOptions} function or customized manually. The resulting JSON
file can be used as input for a pyDarwin model search.
}
\examples{
# Write pyDarwin options to a JSON file
Options <-
  create_pyDarwinOptions(author = "John Doe",
                         algorithm = "GA",
                         population_size = 10)
write_pyDarwinOptions(Options,
                      file = file.path(tempdir(), "options.json"))

}
