% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpressionClass.R
\name{Expression}
\alias{Expression}
\title{Create an Expression object}
\usage{
Expression(
  ExpressionText = character(),
  ContainedStParms = list(),
  State = "Present"
)
}
\arguments{
\item{ExpressionText}{Character string. The primary textual representation of
the expression (e.g., "1-F", "Tlag", "Rate * exp(Effect)").}

\item{ContainedStParms}{List. A list containing any StParm objects that are
referenced by or associated with this \code{ExpressionText.} The \code{State} of
structural parameters depends on the \code{State} of expression (i.e.
specification of \code{State} is not supported).}

\item{State}{Character string. The state of the expression and the associated
structural parameters, controlling its inclusion or search status in the
model. Must be one of 'Present', 'None', or 'Searched'.}
}
\value{
A new object of class \code{Expression}, which is a list containing the
provided arguments (\code{ExpressionText}, \code{ContainedStParms}, \code{State}).
}
\description{
Represents a PML expression that can include text and structural parameters (StParm).
This is used for arguments like tlag, bioavail, duration, or rate in Dosepoint.
}
\examples{
PMLParametersSets <-
get_PMLParametersSets(CompartmentsNumber = c(1, 2, 3),
                      Absorption = c("First-Order"))
# add dosepoint
PMLParametersSets <-
  add_Dosepoint(PMLParametersSets,
                DosepointName = "A1",
                bioavail = Expression("1 - Fa"),
                duration = Expression("Tlag",
                ContainedStParms = list(StParm("Tlag"))))
}
\seealso{
\code{\link[=Dosepoint]{Dosepoint()}}, \code{\link[=StParm]{StParm()}}
}
\concept{Parameter Expressions}
