% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeHR.R
\name{computeHR}
\alias{computeHR}
\title{CardiacDP - computeHR()}
\usage{
computeHR(
  file_path,
  reduce_res = 0.01,
  pop_size = 10L,
  max_gen = 20L,
  patience = 2L,
  an_in = 1,
  acf_thres = 0.5,
  lr_thres = 0.7,
  ncore = NULL,
  output_dir = NULL,
  save_outputs = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{file_path}{Designate the path to your file, must be a .zip or .csv file}

\item{reduce_res}{Time interval of reduced resolution (seconds), by default 0.01}

\item{pop_size}{Number of populations used in the genetic algorithm, by default 10L}

\item{max_gen}{Maximum number of generations in the genetic algorithm, by default 20L}

\item{patience}{Patience threshold (maximum number of generations with no further changes) in the genetic algorithm, by default 2L}

\item{an_in}{Analysis interval (length of a sequence; in minute), by default 1}

\item{acf_thres}{Threshold used in ACF to classify periodic oscillations from aperiodic noises, by default 0.5}

\item{lr_thres}{Linear regression r-sq threshold in extrapolating the tracking index, by default 0.7}

\item{ncore}{Integer; number of CPU cores to use for the genetic algorithm. If NULL (default), uses \code{parallel::detectCores() - 1}. During \verb{R CMD check}, cores are clamped to a small number to satisfy check limits.}

\item{output_dir}{Optional directory to write CSV/PNG outputs when \code{save_outputs = TRUE}. If NULL, defaults to \code{tempdir()}.}

\item{save_outputs}{Logical; if TRUE, write CSV/PNG outputs to \code{output_dir}. Default FALSE.}

\item{verbose}{Logical; if TRUE, emit progress messages. Default FALSE.}
}
\value{
The positions (in indices) and durations of the sub-sequences (finalsubseq) and the corresponding candidate HR (candidateHR) obtained from the genetic algorithm, and the final results evaluating the candidates by autocorrelation values (results_ACF) or the tracking index (results_TI), which contains the details of the subsequences after checking for resolution (subseqHR with Time_min column), the weighted heart rate per sequence (weightedHR with Time_min column) and a plot (plot). If \code{save_outputs = TRUE}, file paths are recorded in \code{output$files}.
}
\description{
Employing the autocorrelation function (ACF) with a genetic algorithm framework to locate periodic sub-sequences within each sequence. From the candidate heart rates of these sub-sequences, the final results are either evaluated based on the autocorrelation value or a tracking index (TI).
}
\examples{
\donttest{
# use the default parameters to analyse a zip file
# the collatedata function will be called automatically
zip_path <- system.file("extdata", "example.zip", package = "CardiacDP")
computeHR(file_path = zip_path, save_outputs = FALSE)
}

\donttest{
# use the default parameters to analyse a csv file
csv_path <- system.file("extdata", "example.csv", package = "CardiacDP")
computeHR(file_path = csv_path, reduce_res = 0.1,
          save_outputs = FALSE)
}

\donttest{
# use customized parameters to analyse a zip file
zip_path <- system.file("extdata", "example.zip", package = "CardiacDP")
computeHR(zip_path, reduce_res = 0.1, max_gen = 30L,
          lr_thres = 0.8, save_outputs = FALSE)
}

\donttest{
# use custom parameters to analyse a csv file
csv_path <- system.file("extdata", "example.csv", package = "CardiacDP")
computeHR(csv_path, reduce_res = 0.1, pop_size = 20L,
          an_in = 1, acf_thres = 0.6, save_outputs = FALSE)
}
}
